/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.transformer.util;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class SignatureUtils {
    private static final String CLASS_EXTENSION = ".class";
    private static final int CLASS_EXTENSION_LENGTH = ".class".length();

    private SignatureUtils() {
    }

    public static String putSlashes(String className) {
        return className.replace('.', '/');
    }

    public static String putDots(String className) {
        return className.replace('/', '.');
    }

    public static int segments(String key, char separator) {
        int segments = 1;
        int index = 0;
        while ((index = key.indexOf(separator, index + 1)) >= 0) {
            ++segments;
        }
        return segments;
    }

    public static int packageMatch(String text, int matchStart, int matchEnd, boolean matchPackageStem) {
        char charBeforeMatch;
        if (matchStart > 0 && ((charBeforeMatch = text.charAt(matchStart - 1)) == '.' || charBeforeMatch == '/' || Character.isJavaIdentifierPart(charBeforeMatch))) {
            return -1;
        }
        int textLength = text.length();
        if (textLength > matchEnd) {
            char charAfterMatch = text.charAt(matchEnd);
            if (Character.isJavaIdentifierPart(charAfterMatch)) {
                return -1;
            }
            if (charAfterMatch == '.' || charAfterMatch == '/') {
                if (matchPackageStem) {
                    int backoff = 1;
                    while (textLength > ++matchEnd) {
                        charAfterMatch = text.charAt(matchEnd);
                        if (charAfterMatch == '.' || charAfterMatch == '/') {
                            backoff = 1;
                            continue;
                        }
                        if (!Character.isJavaIdentifierPart(charAfterMatch) || Character.isUpperCase(charAfterMatch)) break;
                        backoff = 0;
                    }
                    matchEnd -= backoff;
                } else if (textLength > matchEnd + 1 && Character.isJavaIdentifierPart(charAfterMatch = text.charAt(matchEnd + 1)) && !Character.isUpperCase(charAfterMatch)) {
                    return -1;
                }
            }
        }
        return matchEnd;
    }

    public static boolean containsWildcard(String key) {
        int last = key.length() - 1;
        if (last > 1 && key.charAt(last) == '*') {
            char separator = key.charAt(last - 1);
            return separator == '.' || separator == '/';
        }
        return false;
    }

    public static String stripWildcard(String key) {
        return key.substring(0, key.length() - 2);
    }

    public static Stream<String> keyStream(String key, String wildcard) {
        Spliterator<String> spliterator = SignatureUtils.keySpliterator(key, wildcard);
        return StreamSupport.stream(spliterator, false);
    }

    public static Spliterator<String> keySpliterator(String key, String wildcard) {
        return new KeySpliterator(key, wildcard);
    }

    public static String resourceNameToClassName(String resourceName) {
        String className = resourceName.endsWith(CLASS_EXTENSION) ? resourceName.substring(resourceName.length() - CLASS_EXTENSION_LENGTH) : resourceName;
        className = SignatureUtils.putDots(className);
        return className;
    }

    public static String classNameToResourceName(String className) {
        String resourceName = SignatureUtils.putSlashes(className).concat(CLASS_EXTENSION);
        return resourceName;
    }

    static class KeySpliterator
    extends Spliterators.AbstractSpliterator<String> {
        private String key;
        private final String wildcard;

        KeySpliterator(String key, String wildcard) {
            super(SignatureUtils.segments(key, wildcard.charAt(0)) + 1, 1297);
            this.key = key;
            this.wildcard = wildcard;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            if (!this.key.isEmpty()) {
                action.accept(this.key);
                this.advance();
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
            while (!this.key.isEmpty()) {
                action.accept(this.key);
                this.advance();
            }
        }

        private void advance() {
            int lastIndex;
            this.key = SignatureUtils.containsWildcard(this.key) ? ((lastIndex = this.key.lastIndexOf(this.wildcard.charAt(0), this.key.length() - 3)) <= 0 ? "" : this.key.substring(0, lastIndex).concat(this.wildcard)) : this.key.concat(this.wildcard);
        }
    }

    public static class RenameKeyComparator
    implements Comparator<String> {
        private final char separator;

        public RenameKeyComparator(char separator) {
            this.separator = separator;
        }

        @Override
        public int compare(String first, String second) {
            boolean wildSecond;
            boolean wildFirst = SignatureUtils.containsWildcard(first);
            if (wildFirst != (wildSecond = SignatureUtils.containsWildcard(second))) {
                return wildSecond ? -1 : 1;
            }
            int compare = SignatureUtils.segments(second, this.separator) - SignatureUtils.segments(first, this.separator);
            if (compare != 0) {
                return compare;
            }
            return first.compareTo(second);
        }
    }
}

