/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.cors;

import io.quarkus.vertx.http.runtime.cors.CORSConfig;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class CORSFilter
implements Handler<RoutingContext> {
    private static final Pattern COMMA_SEPARATED_SPLIT_REGEX = Pattern.compile("\\s*,\\s*");
    final CORSConfig corsConfig;
    private final boolean wildcardOrigin;
    private final List<Pattern> allowedOriginsRegex;
    private final List<HttpMethod> configuredHttpMethods;

    public CORSFilter(CORSConfig corsConfig) {
        this.corsConfig = corsConfig;
        this.wildcardOrigin = CORSFilter.isOriginConfiguredWithWildcard(this.corsConfig.origins);
        this.allowedOriginsRegex = this.wildcardOrigin ? List.of() : CORSFilter.parseAllowedOriginsRegex(this.corsConfig.origins);
        this.configuredHttpMethods = this.createConfiguredHttpMethods(this.corsConfig.methods);
    }

    private List<HttpMethod> createConfiguredHttpMethods(Optional<List<String>> methods) {
        if (methods.isEmpty()) {
            return List.of();
        }
        List<String> corsConfigMethods = methods.get();
        ArrayList<HttpMethod> result = new ArrayList<HttpMethod>(corsConfigMethods.size());
        for (String value : corsConfigMethods) {
            result.add(HttpMethod.valueOf((String)value));
        }
        return result;
    }

    public static boolean isConfiguredWithWildcard(Optional<List<String>> optionalList) {
        if (optionalList == null || !optionalList.isPresent()) {
            return true;
        }
        List<String> list = optionalList.get();
        return list.isEmpty() || list.size() == 1 && "*".equals(list.get(0));
    }

    private static boolean isOriginConfiguredWithWildcard(Optional<List<String>> origins) {
        return !origins.isEmpty() && origins.get().size() == 1 && "*".equals(origins.get().get(0));
    }

    public static List<Pattern> parseAllowedOriginsRegex(Optional<List<String>> allowedOrigins) {
        if (allowedOrigins == null || !allowedOrigins.isPresent()) {
            return List.of();
        }
        ArrayList<Pattern> allowOriginsRegex = new ArrayList<Pattern>();
        for (String o : allowedOrigins.get()) {
            if (o == null || !o.startsWith("/") || !o.endsWith("/")) continue;
            allowOriginsRegex.add(Pattern.compile(o.substring(1, o.length() - 1)));
        }
        return allowOriginsRegex;
    }

    public static boolean isOriginAllowedByRegex(List<Pattern> allowOriginsRegex, String origin) {
        if (allowOriginsRegex == null) {
            return false;
        }
        for (Pattern pattern : allowOriginsRegex) {
            if (!pattern.matcher(origin).matches()) continue;
            return true;
        }
        return false;
    }

    private void processRequestedHeaders(HttpServerResponse response, String allowHeadersValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.headers)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowHeadersValue);
        } else {
            String[] allowedParts = COMMA_SEPARATED_SPLIT_REGEX.split(allowHeadersValue);
            ArrayList<String> requestedHeaders = new ArrayList<String>(allowedParts.length);
            for (String requestedHeader : allowedParts) {
                requestedHeaders.add(requestedHeader.toLowerCase());
            }
            List<String> corsConfigHeaders = this.corsConfig.headers.get();
            StringBuilder allowedHeaders = new StringBuilder();
            boolean isFirst = true;
            for (String configHeader : corsConfigHeaders) {
                if (!requestedHeaders.contains(configHeader.toLowerCase())) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    allowedHeaders.append(',');
                }
                allowedHeaders.append(configHeader);
            }
            if (allowedHeaders.length() != 0) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_HEADERS, (CharSequence)allowedHeaders.toString());
            }
        }
    }

    private void processMethods(HttpServerResponse response, String allowMethodsValue) {
        if (CORSFilter.isConfiguredWithWildcard(this.corsConfig.methods)) {
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethodsValue);
        } else {
            String[] allowedMethodsParts = COMMA_SEPARATED_SPLIT_REGEX.split(allowMethodsValue);
            ArrayList<String> requestedMethods = new ArrayList<String>(allowedMethodsParts.length);
            for (String requestedMethod : allowedMethodsParts) {
                requestedMethods.add(requestedMethod.toLowerCase());
            }
            StringBuilder allowMethods = new StringBuilder();
            boolean isFirst = true;
            for (HttpMethod configMethod : this.configuredHttpMethods) {
                if (!requestedMethods.contains(configMethod.name().toLowerCase())) continue;
                if (isFirst) {
                    isFirst = false;
                } else {
                    allowMethods.append(',');
                }
                allowMethods.append(configMethod.name());
            }
            if (allowMethods.length() != 0) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_METHODS, (CharSequence)allowMethods.toString());
            }
        }
    }

    public void handle(RoutingContext event) {
        Objects.requireNonNull(this.corsConfig, "CORS config is not set");
        HttpServerRequest request = event.request();
        HttpServerResponse response = event.response();
        String origin = request.getHeader(HttpHeaders.ORIGIN);
        if (origin == null) {
            event.next();
        } else {
            boolean allowsOrigin;
            String requestedHeaders;
            String requestedMethods = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_METHOD);
            if (requestedMethods != null) {
                this.processMethods(response, requestedMethods);
            }
            if ((requestedHeaders = request.getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
                this.processRequestedHeaders(response, requestedHeaders);
            }
            if (!(allowsOrigin = this.wildcardOrigin)) {
                allowsOrigin = !this.corsConfig.origins.isEmpty() ? this.corsConfig.origins.get().contains(origin) || CORSFilter.isOriginAllowedByRegex(this.allowedOriginsRegex, origin) || CORSFilter.isSameOrigin(request, origin) : CORSFilter.isSameOrigin(request, origin);
            }
            if (allowsOrigin) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
            }
            boolean allowCredentials = this.corsConfig.accessControlAllowCredentials.orElseGet(() -> this.corsConfig.origins.isPresent() && this.corsConfig.origins.get().contains(origin) && !origin.equals("*"));
            response.headers().set(HttpHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS, (CharSequence)String.valueOf(allowCredentials));
            Optional<List<String>> exposedHeaders = this.corsConfig.exposedHeaders;
            if (!CORSFilter.isConfiguredWithWildcard(exposedHeaders)) {
                response.headers().set(HttpHeaders.ACCESS_CONTROL_EXPOSE_HEADERS, (CharSequence)String.join((CharSequence)",", exposedHeaders.orElse(Collections.emptyList())));
            }
            if (!allowsOrigin) {
                response.setStatusCode(403);
                response.setStatusMessage("CORS Rejected - Invalid origin");
                response.end();
            } else if (request.method().equals((Object)HttpMethod.OPTIONS) && (requestedHeaders != null || requestedMethods != null)) {
                if (this.corsConfig.accessControlMaxAge.isPresent()) {
                    response.putHeader(HttpHeaders.ACCESS_CONTROL_MAX_AGE, (CharSequence)String.valueOf(this.corsConfig.accessControlMaxAge.get().getSeconds()));
                }
                response.end();
            } else {
                event.next();
            }
        }
    }

    static boolean isSameOrigin(HttpServerRequest request, String origin) {
        if (origin.startsWith(request.scheme())) {
            if (!CORSFilter.substringMatch(origin, request.scheme().length(), "://", false)) {
                return false;
            }
            if (CORSFilter.substringMatch(origin, request.scheme().length() + 3, request.host(), true)) {
                return true;
            }
            return CORSFilter.isSameOriginSlowPath(request, origin);
        }
        return false;
    }

    static boolean isSameOriginSlowPath(HttpServerRequest request, String origin) {
        String absUriString = request.absoluteURI();
        URI baseUri = URI.create(absUriString);
        URI originUri = URI.create(origin);
        if (!originUri.getPath().isEmpty()) {
            return false;
        }
        if (!baseUri.getHost().equals(originUri.getHost())) {
            return false;
        }
        if (baseUri.getPort() == originUri.getPort()) {
            return true;
        }
        if (baseUri.getPort() != -1 && originUri.getPort() != -1) {
            return false;
        }
        return baseUri.getScheme().equals("http") ? !(baseUri.getPort() != 80 && baseUri.getPort() != -1 || originUri.getPort() != 80 && originUri.getPort() != -1) : !(!baseUri.getScheme().equals("https") || baseUri.getPort() != 443 && baseUri.getPort() != -1 || originUri.getPort() != 443 && originUri.getPort() != -1);
    }

    static boolean substringMatch(String str, int pos, String substring, boolean requireFull) {
        int length = str.length();
        int subLength = substring.length();
        int strPos = pos;
        int subPos = 0;
        if (pos + subLength > length) {
            return false;
        }
        while (subPos != subLength) {
            if (str.charAt(strPos) != substring.charAt(subPos)) {
                return false;
            }
            ++strPos;
            ++subPos;
        }
        return !requireFull || strPos == length;
    }
}

