/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.injection;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Singleton;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import javax.ws.rs.sse.Sse;
import org.jboss.resteasy.reactive.server.SimpleResourceInfo;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ResourceContextImpl;
import org.jboss.resteasy.reactive.server.jaxrs.SseImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

@Singleton
public class ContextProducers {
    @RequestScoped
    @Produces
    ServerRequestContext quarkusRestContext() {
        return this.getContext();
    }

    @RequestScoped
    @Produces
    UriInfo uriInfo() {
        return this.getContext().getUriInfo();
    }

    @RequestScoped
    @Produces
    HttpHeaders headers() {
        return this.getContext().getHttpHeaders();
    }

    @ApplicationScoped
    @Produces
    Sse sse() {
        return SseImpl.INSTANCE;
    }

    @RequestScoped
    @Produces
    Request request() {
        return this.getContext().getRequest();
    }

    @ApplicationScoped
    @Produces
    Providers providers() {
        return this.getContext().getProviders();
    }

    @RequestScoped
    @Produces
    ResourceInfo resourceInfo() {
        RuntimeResource target = this.getTarget();
        if (target != null) {
            return target.getLazyMethod();
        }
        return SimpleResourceInfo.NullValues.INSTANCE;
    }

    @RequestScoped
    @Produces
    SimpleResourceInfo simplifiedResourceInfo() {
        RuntimeResource target = this.getTarget();
        if (target != null) {
            return target.getSimplifiedResourceInfo();
        }
        return SimpleResourceInfo.NullValues.INSTANCE;
    }

    private RuntimeResource getTarget() {
        return this.getContext().getTarget();
    }

    @ApplicationScoped
    @Produces
    Configuration config() {
        return this.getContext().getDeployment().getConfiguration();
    }

    @ApplicationScoped
    @Produces
    Application application() {
        return this.getContext().getDeployment().getApplicationSupplier().get();
    }

    @ApplicationScoped
    @Produces
    ResourceContext resourceContext() {
        return ResourceContextImpl.INSTANCE;
    }

    @RequestScoped
    @Produces
    SecurityContext securityContext() {
        return this.getContext().getSecurityContext();
    }

    private ResteasyReactiveRequestContext getContext() {
        ResteasyReactiveRequestContext context = CurrentRequestManager.get();
        if (context == null) {
            throw new IllegalStateException("No RESTEasy Reactive request in progress");
        }
        return context;
    }
}

