/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.kie.api.io.Resource;

public class InputStreamResource
extends BaseResource
implements InternalResource {
    private transient InputStream stream;
    private String encoding;

    public InputStreamResource() {
    }

    public InputStreamResource(InputStream stream) {
        this(stream, null);
    }

    public InputStreamResource(InputStream stream, String encoding) {
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.stream = stream;
        this.encoding = encoding;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.encoding = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.getBytes();
        super.writeExternal(out);
        out.writeObject(this.encoding);
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes == null) {
            try {
                this.bytes = IoUtils.readBytesFromInputStream(this.stream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("InputStream cannot be resolved to URL");
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }
}

