/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategyTarget;
import org.testcontainers.utility.DockerImageName;

public class PostgreSQLContainer<SELF extends PostgreSQLContainer<SELF>>
extends JdbcDatabaseContainer<SELF> {
    public static final String NAME = "postgresql";
    public static final String IMAGE = "postgres";
    public static final String DEFAULT_TAG = "9.6.12";
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"postgres");
    public static final Integer POSTGRESQL_PORT = 5432;
    static final String DEFAULT_USER = "test";
    static final String DEFAULT_PASSWORD = "test";
    private String databaseName = "test";
    private String username = "test";
    private String password = "test";
    private static final String FSYNC_OFF_OPTION = "fsync=off";

    @Deprecated
    public PostgreSQLContainer() {
        this(DEFAULT_IMAGE_NAME.withTag(DEFAULT_TAG));
    }

    public PostgreSQLContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public PostgreSQLContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{DEFAULT_IMAGE_NAME});
        this.waitStrategy = new LogMessageWaitStrategy().withRegEx(".*database system is ready to accept connections.*\\s").withTimes(2).withStartupTimeout(Duration.of(60L, ChronoUnit.SECONDS));
        this.setCommand(new String[]{IMAGE, "-c", FSYNC_OFF_OPTION});
        this.addExposedPort(POSTGRESQL_PORT);
    }

    @NotNull
    protected Set<Integer> getLivenessCheckPorts() {
        return Collections.singleton(this.getMappedPort(POSTGRESQL_PORT));
    }

    protected void configure() {
        this.withUrlParam("loggerLevel", "OFF");
        this.addEnv("POSTGRES_DB", this.databaseName);
        this.addEnv("POSTGRES_USER", this.username);
        this.addEnv("POSTGRES_PASSWORD", this.password);
    }

    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    public String getJdbcUrl() {
        String additionalUrlParams = this.constructUrlParameters("?", "&");
        return "jdbc:postgresql://" + this.getHost() + ":" + this.getMappedPort(POSTGRESQL_PORT) + "/" + this.databaseName + additionalUrlParams;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTestQueryString() {
        return "SELECT 1";
    }

    public SELF withDatabaseName(String databaseName) {
        this.databaseName = databaseName;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withUsername(String username) {
        this.username = username;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    public SELF withPassword(String password) {
        this.password = password;
        return (SELF)((Object)((PostgreSQLContainer)this.self()));
    }

    protected void waitUntilContainerStarted() {
        this.getWaitStrategy().waitUntilReady((WaitStrategyTarget)this);
    }
}

