/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.h2.runtime.graal;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import org.h2.engine.ConnectionInfo;

@TargetClass(value=ConnectionInfo.class)
public final class RemoteOnly {
    @Alias
    private boolean remote;

    @Substitute
    @AlwaysInline(value="Method org.h2.engine.SessionRemote.connectEmbeddedOrServer must be able to realize it's only ever going remote")
    public boolean isRemote() {
        if (!this.remote) {
            throw new UnsupportedOperationException("H2 database compiled into a native-image is only functional as a client: can't create an Embedded Database Session");
        }
        return true;
    }
}

