/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.models.drools.ast.factories;

import java.util.List;
import org.dmg.pmml.CompoundPredicate;
import org.drools.core.util.StringUtils;
import org.kie.pmml.api.exceptions.KiePMMLException;
import org.kie.pmml.models.drools.ast.KiePMMLDroolsRule;
import org.kie.pmml.models.drools.ast.KiePMMLFieldOperatorValue;
import org.kie.pmml.models.drools.ast.factories.KiePMMLAbstractPredicateASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLCompoundPredicateWithAccumulationASTFactory;
import org.kie.pmml.models.drools.ast.factories.KiePMMLCompoundPredicateWithResultASTFactory;
import org.kie.pmml.models.drools.ast.factories.PredicateASTFactoryData;
import org.kie.pmml.models.drools.tuples.KiePMMLReasonCodeAndValue;
import org.kie.pmml.models.drools.utils.KiePMMLASTFactoryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KiePMMLCompoundPredicateASTFactory
extends KiePMMLAbstractPredicateASTFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)KiePMMLCompoundPredicateASTFactory.class.getName());

    private KiePMMLCompoundPredicateASTFactory(PredicateASTFactoryData predicateASTFactoryData) {
        super(predicateASTFactoryData);
    }

    public static KiePMMLCompoundPredicateASTFactory factory(PredicateASTFactoryData predicateASTFactoryData) {
        return new KiePMMLCompoundPredicateASTFactory(predicateASTFactoryData);
    }

    public void declareRuleFromCompoundPredicate(Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromCompoundPredicate {} {} {}", new Object[]{toAccumulate, statusToSet, isLastCharacteristic});
        CompoundPredicate compoundPredicate = (CompoundPredicate)this.predicateASTFactoryData.getPredicate();
        switch (compoundPredicate.getBooleanOperator()) {
            case SURROGATE: {
                String agendaActivationGroup = String.format("%s_surrogate", this.predicateASTFactoryData.getCurrentRule());
                this.declareRuleFromCompoundPredicateSurrogate(agendaActivationGroup, statusToSet);
                KiePMMLCompoundPredicateWithAccumulationASTFactory.declareRuleFromCompoundPredicateSurrogate(this.predicateASTFactoryData, agendaActivationGroup, toAccumulate, statusToSet, reasonCodeAndValue, isLastCharacteristic);
                break;
            }
            case AND: {
                this.declareRuleFromCompoundPredicateAndOrXor(toAccumulate, statusToSet, reasonCodeAndValue, isLastCharacteristic);
                break;
            }
            case OR: {
                this.declareRuleFromCompoundPredicateAndOrXor(toAccumulate, statusToSet, reasonCodeAndValue, isLastCharacteristic);
                break;
            }
            case XOR: {
                this.declareRuleFromCompoundPredicateAndOrXor(toAccumulate, statusToSet, reasonCodeAndValue, isLastCharacteristic);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown CompoundPredicate.booleanOperator %st", compoundPredicate.getBooleanOperator()));
            }
        }
    }

    public void declareRuleFromCompoundPredicate(Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromCompoundPredicate {} {}", result, (Object)isFinalLeaf);
        CompoundPredicate compoundPredicate = (CompoundPredicate)this.predicateASTFactoryData.getPredicate();
        switch (compoundPredicate.getBooleanOperator()) {
            case SURROGATE: {
                String agendaActivationGroup = String.format("%s_surrogate", this.predicateASTFactoryData.getCurrentRule());
                this.declareRuleFromCompoundPredicateSurrogate(agendaActivationGroup, null);
                KiePMMLCompoundPredicateWithResultASTFactory.declareRuleFromCompoundPredicateSurrogate(this.predicateASTFactoryData, agendaActivationGroup, result, isFinalLeaf);
                break;
            }
            case AND: {
                this.declareRuleFromCompoundPredicateAndOrXor(result, isFinalLeaf);
                break;
            }
            case OR: {
                this.declareRuleFromCompoundPredicateAndOrXor(result, isFinalLeaf);
                break;
            }
            case XOR: {
                this.declareRuleFromCompoundPredicateAndOrXor(result, isFinalLeaf);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown CompoundPredicate.booleanOperator %st", compoundPredicate.getBooleanOperator()));
            }
        }
    }

    private void declareRuleFromCompoundPredicateAndOrXor(Number toAccumulate, String statusToSet, KiePMMLReasonCodeAndValue reasonCodeAndValue, boolean isLastCharacteristic) {
        logger.trace("declareRuleFromCompoundPredicateAndOrXor {} {} {}", new Object[]{toAccumulate, statusToSet, isLastCharacteristic});
        KiePMMLDroolsRule.Builder builder = this.getBuilderForCompoundPredicateAndOrXor(statusToSet).withAccumulation(toAccumulate);
        KiePMMLCompoundPredicateWithAccumulationASTFactory.declareRuleFromCompoundPredicateAndOrXor(builder, this.predicateASTFactoryData.getRules(), reasonCodeAndValue, isLastCharacteristic);
    }

    private void declareRuleFromCompoundPredicateAndOrXor(Object result, boolean isFinalLeaf) {
        logger.trace("declareRuleFromCompoundPredicateAndOrXor {} {}", result, (Object)isFinalLeaf);
        String statusToSet = isFinalLeaf ? "DONE" : this.predicateASTFactoryData.getCurrentRule();
        KiePMMLDroolsRule.Builder builder = this.getBuilderForCompoundPredicateAndOrXor(statusToSet);
        KiePMMLCompoundPredicateWithResultASTFactory.declareRuleFromCompoundPredicateAndOrXor(builder, this.predicateASTFactoryData.getRules(), result, isFinalLeaf);
    }

    private KiePMMLDroolsRule.Builder getBuilderForCompoundPredicateAndOrXor(String statusToSet) {
        logger.trace("getBuilderForCompoundPredicateAndOrXor {}", (Object)statusToSet);
        CompoundPredicate compoundPredicate = (CompoundPredicate)this.predicateASTFactoryData.getPredicate();
        if (!(CompoundPredicate.BooleanOperator.AND.equals((Object)compoundPredicate.getBooleanOperator()) || CompoundPredicate.BooleanOperator.OR.equals((Object)compoundPredicate.getBooleanOperator()) || CompoundPredicate.BooleanOperator.XOR.equals((Object)compoundPredicate.getBooleanOperator()))) {
            throw new KiePMMLException(String.format("getBuilderForCompoundPredicateAndOrXor invoked with %s CompoundPredicate", compoundPredicate.getBooleanOperator()));
        }
        String statusConstraint = StringUtils.isEmpty((CharSequence)this.predicateASTFactoryData.getParentPath()) ? "status == null" : String.format("status == \"%s\"", this.predicateASTFactoryData.getParentPath());
        KiePMMLDroolsRule.Builder toReturn = KiePMMLDroolsRule.builder(this.predicateASTFactoryData.getCurrentRule(), statusToSet, this.predicateASTFactoryData.getOutputFields()).withStatusConstraint(statusConstraint);
        switch (compoundPredicate.getBooleanOperator()) {
            case AND: {
                List<KiePMMLFieldOperatorValue> constraints = KiePMMLASTFactoryUtils.getConstraintEntriesFromAndOrCompoundPredicate(compoundPredicate, this.predicateASTFactoryData.getFieldTypeMap());
                toReturn = toReturn.withAndConstraints(constraints);
                break;
            }
            case OR: {
                List<KiePMMLFieldOperatorValue> constraints = KiePMMLASTFactoryUtils.getConstraintEntriesFromAndOrCompoundPredicate(compoundPredicate, this.predicateASTFactoryData.getFieldTypeMap());
                toReturn = toReturn.withOrConstraints(constraints);
                break;
            }
            case XOR: {
                List<KiePMMLFieldOperatorValue> constraints = KiePMMLASTFactoryUtils.getConstraintEntriesFromXOrCompoundPredicate(compoundPredicate, this.predicateASTFactoryData.getFieldTypeMap());
                toReturn = toReturn.withXorConstraints(constraints);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("CompoundPredicate.booleanOperator should never be %s at this point", compoundPredicate.getBooleanOperator()));
            }
        }
        return toReturn;
    }

    private void declareRuleFromCompoundPredicateSurrogate(String agendaActivationGroup, String statusToSet) {
        logger.trace("declareRuleFromCompoundPredicateSurrogate {} {}", (Object)agendaActivationGroup, (Object)statusToSet);
        CompoundPredicate compoundPredicate = (CompoundPredicate)this.predicateASTFactoryData.getPredicate();
        if (!CompoundPredicate.BooleanOperator.SURROGATE.equals((Object)compoundPredicate.getBooleanOperator())) {
            throw new KiePMMLException(String.format("declareRuleFromCompoundPredicateSurrogate invoked with %s CompoundPredicate", compoundPredicate.getBooleanOperator()));
        }
        KiePMMLDroolsRule.Builder builder = KiePMMLDroolsRule.builder(this.predicateASTFactoryData.getCurrentRule(), null, this.predicateASTFactoryData.getOutputFields()).withStatusConstraint(String.format("status == \"%s\"", this.predicateASTFactoryData.getParentPath())).withFocusedAgendaGroup(agendaActivationGroup);
        this.predicateASTFactoryData.getRules().add(builder.build());
    }
}

