/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.narayana.jta.runtime;

import com.arjuna.ats.arjuna.common.CoreEnvironmentBeanException;
import com.arjuna.ats.arjuna.common.ObjectStoreEnvironmentBean;
import com.arjuna.ats.arjuna.common.RecoveryEnvironmentBean;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.TransactionReaper;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.jta.common.JTAEnvironmentBean;
import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import com.arjuna.common.util.propertyservice.PropertiesFactory;
import io.quarkus.narayana.jta.runtime.QuarkusPropertiesFactory;
import io.quarkus.narayana.jta.runtime.TransactionManagerConfiguration;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;

@Recorder
public class NarayanaJtaRecorder {
    private static Properties defaultProperties;
    private static final Logger log;

    public void setNodeName(TransactionManagerConfiguration transactions) {
        try {
            arjPropertyManager.getCoreEnvironmentBean().setNodeIdentifier(transactions.nodeName);
            jtaPropertyManager.getJTAEnvironmentBean().setXaRecoveryNodes(Collections.singletonList(transactions.nodeName));
            TxControl.setXANodeName((String)transactions.nodeName);
        }
        catch (CoreEnvironmentBeanException e) {
            e.printStackTrace();
        }
    }

    public void setDefaultProperties(Properties properties) {
        properties.putAll((Map<?, ?>)System.getProperties());
        try {
            Field field = PropertiesFactory.class.getDeclaredField("delegatePropertiesFactory");
            field.setAccessible(true);
            field.set(null, (Object)new QuarkusPropertiesFactory(properties));
        }
        catch (Exception e) {
            log.error((Object)"Could not override transaction properties factory", (Throwable)e);
        }
        defaultProperties = properties;
    }

    public void setDefaultTimeout(TransactionManagerConfiguration transactions) {
        arjPropertyManager.getCoordinatorEnvironmentBean().setDefaultTimeout((int)transactions.defaultTransactionTimeout.getSeconds());
        TxControl.setDefaultTimeout((int)((int)transactions.defaultTransactionTimeout.getSeconds()));
    }

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public void disableTransactionStatusManager() {
        arjPropertyManager.getCoordinatorEnvironmentBean().setTransactionStatusManagerEnable(false);
    }

    public void setConfig(TransactionManagerConfiguration transactions) {
        ((ObjectStoreEnvironmentBean)BeanPopulator.getDefaultInstance(ObjectStoreEnvironmentBean.class)).setObjectStoreDir(transactions.objectStoreDirectory);
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"communicationStore")).setObjectStoreDir(transactions.objectStoreDirectory);
        ((ObjectStoreEnvironmentBean)BeanPopulator.getNamedInstance(ObjectStoreEnvironmentBean.class, (String)"stateStore")).setObjectStoreDir(transactions.objectStoreDirectory);
        ((RecoveryEnvironmentBean)BeanPopulator.getDefaultInstance(RecoveryEnvironmentBean.class)).setRecoveryModuleClassNames(transactions.recoveryModules);
        ((RecoveryEnvironmentBean)BeanPopulator.getDefaultInstance(RecoveryEnvironmentBean.class)).setExpiryScannerClassNames(transactions.expiryScanners);
        ((JTAEnvironmentBean)BeanPopulator.getDefaultInstance(JTAEnvironmentBean.class)).setXaResourceOrphanFilterClassNames(transactions.xaResourceOrphanFilters);
    }

    public void handleShutdown(ShutdownContext context, final TransactionManagerConfiguration transactions) {
        context.addLastShutdownTask(new Runnable(){

            @Override
            public void run() {
                if (transactions.enableRecovery) {
                    RecoveryManager.manager().terminate(true);
                }
                TransactionReaper.terminate((boolean)false);
            }
        });
    }

    static {
        log = Logger.getLogger(NarayanaJtaRecorder.class);
    }
}

