/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mariadb.jdbc.export.HaMode;

public class HostAddress {
    public final String host;
    public int port;
    public Boolean primary;

    private HostAddress(String host, int port, Boolean primary) {
        this.host = host;
        this.port = port;
        this.primary = primary;
    }

    public static HostAddress from(String host, int port) {
        return new HostAddress(host, port, null);
    }

    public static HostAddress from(String host, int port, boolean primary) {
        return new HostAddress(host, port, primary);
    }

    public static List<HostAddress> parse(String spec, HaMode haMode) throws SQLException {
        if ("".equals(spec)) {
            return new ArrayList<HostAddress>(0);
        }
        String[] tokens = spec.trim().split(",");
        int size = tokens.length;
        ArrayList<HostAddress> arr = new ArrayList<HostAddress>(size);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.startsWith("address=")) {
                arr.add(HostAddress.parseParameterHostAddress(token, haMode, i == 0));
                continue;
            }
            arr.add(HostAddress.parseSimpleHostAddress(token, haMode, i == 0));
        }
        return arr;
    }

    private static HostAddress parseSimpleHostAddress(String str, HaMode haMode, boolean first) throws SQLException {
        String host;
        int port = 3306;
        if (str.charAt(0) == '[') {
            int ind = str.indexOf(93);
            host = str.substring(1, ind);
            if (ind != str.length() - 1 && str.charAt(ind + 1) == ':') {
                port = HostAddress.getPort(str.substring(ind + 2));
            }
        } else if (str.contains(":")) {
            String[] hostPort = str.split(":");
            host = hostPort[0];
            port = HostAddress.getPort(hostPort[1]);
        } else {
            host = str;
        }
        boolean primary = haMode != HaMode.REPLICATION || first;
        return new HostAddress(host, port, primary);
    }

    private static int getPort(String portString) throws SQLException {
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException nfe) {
            throw new SQLException("Incorrect port value : " + portString);
        }
    }

    private static HostAddress parseParameterHostAddress(String str, HaMode haMode, boolean first) throws SQLException {
        String host = null;
        int port = 3306;
        Boolean primary = null;
        String[] array = str.replace(" ", "").split("(?=\\()|(?<=\\))");
        block10: for (int i = 1; i < array.length; ++i) {
            String[] token = array[i].replace("(", "").replace(")", "").trim().split("=");
            if (token.length != 2) {
                throw new IllegalArgumentException("Invalid connection URL, expected key=value pairs, found " + array[i]);
            }
            String key = token[0].toLowerCase();
            String value = token[1].toLowerCase();
            switch (key) {
                case "host": {
                    host = value.replace("[", "").replace("]", "");
                    continue block10;
                }
                case "port": {
                    port = HostAddress.getPort(value);
                    continue block10;
                }
                case "type": {
                    if ("master".equalsIgnoreCase(value) || "primary".equalsIgnoreCase(value)) {
                        primary = true;
                        continue block10;
                    }
                    if ("slave".equalsIgnoreCase(value) || "replica".equalsIgnoreCase(value)) {
                        primary = false;
                        continue block10;
                    }
                    throw new SQLException(String.format("Wrong type value %s (possible value primary/replica)", array[i]));
                }
            }
        }
        if (primary == null) {
            primary = haMode == HaMode.REPLICATION ? Boolean.valueOf(first) : Boolean.valueOf(true);
        }
        return new HostAddress(host, port, primary);
    }

    public String toString() {
        return String.format("address=(host=%s)(port=%s)%s", this.host, this.port, this.primary != null ? "(type=" + (this.primary != false ? "primary)" : "replica)") : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAddress that = (HostAddress)o;
        return this.port == that.port && Objects.equals(this.host, that.host) && Objects.equals(this.primary, that.primary);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.primary);
    }
}

