/*
 * Decompiled with CFR 0.152.
 */
package org.kie.remote.services.rest.api;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiImplicitParam;
import com.wordnik.swagger.annotations.ApiImplicitParams;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentDescriptor;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentJobResult;
import org.kie.services.client.serialization.jaxb.impl.deploy.JaxbDeploymentUnit;
import org.kie.services.client.serialization.jaxb.impl.process.JaxbProcessDefinitionList;

@Path(value="/deployment/{deploymentId: [\\w\\.-]+(:[\\w\\.-]+){2,2}(:[\\w\\.-]*){0,2}}")
@Api(value="/deployment/{deploymentId}", description="Deployment unit management operations")
public interface DeploymentResource {
    @GET
    @ApiOperation(value="Retrieve basic information, including the status, of a deployment unit", position=0, produces="application/xml, application/json", response=JaxbDeploymentUnit.class)
    public Response getConfig();

    @POST
    @Path(value="/deploy")
    @ApiOperation(value="Deploy a deployment unit", notes="Submits an asynchronous request; takes an optional JaxbDeploymentDescriptor argument for more fine-grained configuration of the configuration", position=1, consumes="application/xml, application/json", produces="application/xml, application/json", response=JaxbDeploymentJobResult.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="strategy", value="The runtime strategy for process instances from the deployment unit", allowableValues="SINGLETON, PER_REQUEST, PER_PROCESS_INSTANCE (case is ignored)", allowMultiple=false, paramType="query", required=false, defaultValue="SINGLETON"), @ApiImplicitParam(name="mergemode", value="The merging strategy used when deploying the deployment unit", allowableValues="KEEP_ALL, OVERRIDE_ALL, OVERRIDE_EMPTY, MERGE_COLLECTIONS (case is ignored)", allowMultiple=false, paramType="query", required=false, defaultValue="MERGE_COLLECTIONS")})
    @ApiResponses(value={@ApiResponse(code=202, message="Request accepted")})
    public Response deploy(JaxbDeploymentDescriptor var1);

    @POST
    @Path(value="/undeploy")
    @ApiOperation(value="Undeploy a deployment unit", notes="Submits an asynchronous request", position=2, produces="application/xml, application/json", response=JaxbDeploymentJobResult.class)
    @ApiResponses(value={@ApiResponse(code=202, message="Request accepted")})
    public Response undeploy();

    @GET
    @Path(value="/processes")
    @ApiOperation(value="Retrieve a list of process definition info for a deployment unit", notes="The list is sorted alphabetically by process id", position=3, produces="application/xml, application/json", response=JaxbProcessDefinitionList.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="page", value="The page number of the results (the abbreviated version 'p' is also acceptable)", allowMultiple=false, paramType="query", required=false), @ApiImplicitParam(name="pagesize", value="The page size used for the results (the abbreviated version 's' is also acceptable)", allowMultiple=false, paramType="query", required=false)})
    public Response listProcessDefinitions();
}

