/*
 * Decompiled with CFR 0.152.
 */
package org.kie.hacep.sample.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import org.kie.hacep.sample.kjar.StockTickEvent;
import org.kie.remote.CommonConfig;
import org.kie.remote.TopicsConfig;
import org.kie.remote.impl.RemoteStreamingKieSessionImpl;
import org.kie.remote.impl.producer.Producer;
import org.kie.remote.util.KafkaRemoteUtil;

public class ClientProducerDemo {
    public static void main(String[] args) {
        try {
            ClientProducerDemo.insertBatchEvent(1);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private static void insertBatchEvent(int items) throws IOException {
        TopicsConfig envConfig = TopicsConfig.getDefaultTopicsConfig();
        Properties props = ClientProducerDemo.getProperties();
        Producer prod = KafkaRemoteUtil.getProducer((boolean)false);
        try (RemoteStreamingKieSessionImpl producer = new RemoteStreamingKieSessionImpl(props, envConfig, KafkaRemoteUtil.getListener((Properties)props, (boolean)false), prod);){
            for (int i = 0; i < items; ++i) {
                StockTickEvent eventA = new StockTickEvent("RHT", (double)ThreadLocalRandom.current().nextLong(80L, 100L));
                producer.insert((Serializable)eventA);
            }
        }
    }

    private static Properties getProperties() throws IOException {
        Properties props = CommonConfig.getStatic();
        try (InputStream is = ClientProducerDemo.class.getClassLoader().getResourceAsStream("configuration.properties");){
            props.load(is);
        }
        catch (IOException io) {
            io.printStackTrace();
            throw io;
        }
        return props;
    }
}

