/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kie.server.api.Version;

public class KieServerEnvironment {
    private static final Pattern VERSION_PAT;
    private static Version version;
    private static String serverId;
    private static String username;
    private static String password;

    public static Version getVersion() {
        return version;
    }

    public static String getServerId() {
        return serverId;
    }

    public static void setServerId(String serverIdIn) {
        serverId = serverIdIn;
    }

    public static String getUsername() {
        return username;
    }

    public static String getPassword() {
        return password;
    }

    static {
        Matcher m;
        VERSION_PAT = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)([\\.-].*)?");
        username = System.getProperty("org.kie.server.user", "kieserver");
        password = System.getProperty("org.kie.server.pwd", "kieserver1!");
        String kieServerString = KieServerEnvironment.class.getPackage().getImplementationVersion();
        if (kieServerString == null) {
            InputStream is = null;
            try {
                is = KieServerEnvironment.class.getClassLoader().getResourceAsStream("kie.server.properties");
                Properties properties = new Properties();
                properties.load(is);
                kieServerString = properties.get("kie.server.version").toString();
                is.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        if ((m = VERSION_PAT.matcher(kieServerString)).matches()) {
            try {
                version = new Version(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3)), m.group(4));
            }
            catch (NumberFormatException e) {
                version = new Version(0, 0, 0, null);
            }
        }
    }
}

