/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.definition;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="process-definition")
public class ProcessDefinition {
    @XmlElement(name="process-id")
    private String id;
    @XmlElement(name="process-name")
    private String name;
    @XmlElement(name="process-version")
    private String version;
    @XmlElement(name="package")
    private String packageName;
    @XmlElement(name="container-id")
    private String containerId;
    @XmlElementWrapper(name="associated-entities")
    private Map<String, String[]> associatedEntities;
    @XmlElementWrapper(name="service-tasks")
    private Map<String, String> serviceTasks;
    @XmlElementWrapper(name="process-variables")
    private Map<String, String> processVariables;
    @XmlElementWrapper(name="process-subprocesses")
    private Collection<String> reusableSubProcesses;

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public Map<String, String[]> getAssociatedEntities() {
        return this.associatedEntities;
    }

    public void setAssociatedEntities(Map<String, String[]> associatedEntities) {
        this.associatedEntities = associatedEntities;
    }

    public Map<String, String> getServiceTasks() {
        return this.serviceTasks;
    }

    public void setServiceTasks(Map<String, String> serviceTasks) {
        this.serviceTasks = serviceTasks;
    }

    public Map<String, String> getProcessVariables() {
        return this.processVariables;
    }

    public void setProcessVariables(Map<String, String> processVariables) {
        this.processVariables = processVariables;
    }

    public Collection<String> getReusableSubProcesses() {
        return this.reusableSubProcesses;
    }

    public void setReusableSubProcesses(Collection<String> reusableSubProcesses) {
        this.reusableSubProcesses = reusableSubProcesses;
    }

    public static class Builder {
        private ProcessDefinition definition = new ProcessDefinition();

        public ProcessDefinition build() {
            return this.definition;
        }

        public Builder id(String id) {
            this.definition.setId(id);
            return this;
        }

        public Builder name(String name) {
            this.definition.setName(name);
            return this;
        }

        public Builder version(String version) {
            this.definition.setVersion(version);
            return this;
        }

        public Builder packageName(String packageName) {
            this.definition.setPackageName(packageName);
            return this;
        }

        public Builder containerId(String containerId) {
            this.definition.setContainerId(containerId);
            return this;
        }

        public Builder entitiesAsCollection(Map<String, Collection<String>> entities) {
            HashMap<String, String[]> data = new HashMap<String, String[]>();
            for (Map.Entry<String, Collection<String>> entry : entities.entrySet()) {
                data.put(entry.getKey(), entry.getValue().toArray(new String[entry.getValue().size()]));
            }
            this.definition.setAssociatedEntities(data);
            return this;
        }

        public Builder entities(Map<String, String[]> entities) {
            this.definition.setAssociatedEntities(entities);
            return this;
        }

        public Builder serviceTasks(Map<String, String> serviceTasks) {
            this.definition.setServiceTasks(serviceTasks);
            return this;
        }

        public Builder variables(Map<String, String> variables) {
            this.definition.setProcessVariables(variables);
            return this;
        }

        public Builder subprocesses(Collection<String> subprocesses) {
            this.definition.setReusableSubProcesses(subprocesses);
            return this;
        }
    }
}

