/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling.json;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.deser.std.UntypedObjectDeserializer;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;
import org.drools.core.xml.jaxb.util.JaxbListAdapter;
import org.drools.core.xml.jaxb.util.JaxbListWrapper;
import org.drools.core.xml.jaxb.util.JaxbUnknownAdapter;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Wrapped;
import org.kie.server.api.model.type.JaxbByteArray;

public class JSONMarshaller
implements Marshaller {
    private static boolean formatDate = Boolean.parseBoolean(System.getProperty("org.kie.server.json.format.date", "false"));
    private static String dateFormatStr = System.getProperty("org.kie.server.json.date_format", "yyyy-MM-dd'T'hh:mm:ss.SSSZ");
    private ClassLoader classLoader;
    private final ObjectMapper objectMapper;
    private final ObjectMapper fallbackObjectMapper;
    private DateFormat dateFormat = new SimpleDateFormat(dateFormatStr);

    public JSONMarshaller(Set<Class<?>> classes, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.objectMapper = new ObjectMapper();
        ObjectMapper customSerializationMapper = new ObjectMapper();
        if (classes == null) {
            classes = new HashSet();
        }
        classes.add(JaxbByteArray.class);
        List<NamedType> customClasses = this.prepareCustomClasses(classes);
        ExtendedJaxbAnnotationIntrospector primary = new ExtendedJaxbAnnotationIntrospector(customClasses, customSerializationMapper);
        JacksonAnnotationIntrospector secondary = new JacksonAnnotationIntrospector();
        AnnotationIntrospector.Pair introspectorPair = new AnnotationIntrospector.Pair((AnnotationIntrospector)primary, (AnnotationIntrospector)secondary);
        this.objectMapper.setDeserializationConfig(this.objectMapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair).without(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES}).with(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}));
        this.objectMapper.setSerializationConfig(this.objectMapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair).with(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT}));
        customSerializationMapper.setDeserializationConfig(customSerializationMapper.getDeserializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair));
        customSerializationMapper.setSerializationConfig(customSerializationMapper.getSerializationConfig().withAnnotationIntrospector((AnnotationIntrospector)introspectorPair).with(new SerializationConfig.Feature[]{SerializationConfig.Feature.INDENT_OUTPUT}));
        if (classes != null && !classes.isEmpty()) {
            ObjectMapper customObjectMapper = new ObjectMapper();
            customObjectMapper.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_OBJECT);
            SimpleModule mod = new SimpleModule("custom-object-mapper", Version.unknownVersion());
            mod.addDeserializer(Object.class, (JsonDeserializer)new CustomObjectDeserializer(classes));
            CustomObjectSerializer customObjectSerializer = new CustomObjectSerializer(customObjectMapper);
            for (Class<?> clazz : classes) {
                mod.addSerializer(clazz, (JsonSerializer)customObjectSerializer);
            }
            this.objectMapper.registerModule((Module)mod);
            customSerializationMapper.registerModule((Module)mod);
        }
        this.fallbackObjectMapper = new ObjectMapper();
        if (formatDate) {
            this.objectMapper.setDateFormat(this.dateFormat);
            this.fallbackObjectMapper.setDateFormat(this.dateFormat);
            customSerializationMapper.setDateFormat(this.dateFormat);
            this.objectMapper.getDeserializationConfig().withDateFormat(this.dateFormat);
            this.fallbackObjectMapper.getDeserializationConfig().withDateFormat(this.dateFormat);
            customSerializationMapper.getDeserializationConfig().withDateFormat(this.dateFormat);
            this.objectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
            this.fallbackObjectMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
            customSerializationMapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        }
    }

    protected List<NamedType> prepareCustomClasses(Set<Class<?>> classes) {
        ArrayList<NamedType> customClasses = new ArrayList<NamedType>();
        if (classes != null) {
            for (Class<?> clazz : classes) {
                customClasses.add(new NamedType(clazz, clazz.getSimpleName()));
                customClasses.add(new NamedType(clazz, clazz.getName()));
            }
        }
        return customClasses;
    }

    @Override
    public String marshall(Object objectInput) {
        try {
            return this.objectMapper.writeValueAsString(this.wrap(objectInput));
        }
        catch (IOException e) {
            throw new MarshallingException("Error marshalling input", e);
        }
    }

    @Override
    public <T> T unmarshall(String serializedInput, Class<T> type) {
        try {
            return (T)this.unwrap(this.objectMapper.readValue(serializedInput, type));
        }
        catch (JsonMappingException e) {
            try {
                return (T)this.unwrap(this.fallbackObjectMapper.readValue(serializedInput, type));
            }
            catch (IOException iOException) {
                throw new MarshallingException("Error unmarshalling input", e);
            }
        }
        catch (IOException e) {
            throw new MarshallingException("Error unmarshalling input", e);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public MarshallingFormat getFormat() {
        return MarshallingFormat.JSON;
    }

    protected Object wrap(Object data) {
        if (data instanceof byte[]) {
            return new JaxbByteArray((byte[])data);
        }
        return data;
    }

    protected Object unwrap(Object data) {
        if (data instanceof Wrapped) {
            return ((Wrapped)data).unwrap();
        }
        return data;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    class CustomObjectDeserializer
    extends UntypedObjectDeserializer {
        private final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)*\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
        private static final long serialVersionUID = 7764405880012867708L;
        private Map<String, Class<?>> classes = new HashMap();

        public CustomObjectDeserializer(Set<Class<?>> classes) {
            for (Class<?> c : classes) {
                this.classes.put(c.getSimpleName(), c);
                this.classes.put(c.getName(), c);
            }
        }

        protected Object mapObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.START_OBJECT) {
                t = jp.nextToken();
            }
            if (t != JsonToken.FIELD_NAME) {
                return new LinkedHashMap(4);
            }
            String field1 = jp.getText();
            jp.nextToken();
            if (this.classes.containsKey(field1)) {
                Object value = JSONMarshaller.this.objectMapper.readValue(jp, this.classes.get(field1));
                jp.nextToken();
                return value;
            }
            if (this.isFullyQualifiedClassname(field1)) {
                try {
                    Object value = JSONMarshaller.this.objectMapper.readValue(jp, Class.forName(field1, true, JSONMarshaller.this.classLoader));
                    jp.nextToken();
                    return value;
                }
                catch (ClassNotFoundException value) {
                    // empty catch block
                }
            }
            Object value1 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                return result;
            }
            String field2 = jp.getText();
            jp.nextToken();
            Object value2 = this.deserialize(jp, ctxt);
            if (jp.nextToken() != JsonToken.FIELD_NAME) {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(4);
                result.put(field1, value1);
                result.put(field2, value2);
                return result;
            }
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            result.put(field1, value1);
            result.put(field2, value2);
            do {
                String fieldName = jp.getText();
                jp.nextToken();
                result.put(fieldName, this.deserialize(jp, ctxt));
            } while (jp.nextToken() != JsonToken.END_OBJECT);
            if (result.containsKey("type") && result.containsKey("componentType") && result.containsKey("element")) {
                JaxbListWrapper wrapper = new JaxbListWrapper();
                wrapper.setType(JaxbListWrapper.JaxbWrapperType.valueOf((String)((String)result.get("type"))));
                wrapper.setComponentType((String)result.get("componentType"));
                wrapper.setElements(this.toArray(result.get("element")));
                try {
                    Object data = null;
                    if (wrapper.getType().equals((Object)JaxbListWrapper.JaxbWrapperType.MAP)) {
                        LinkedHashMap tranformed = new LinkedHashMap();
                        for (Object element : wrapper.getElements()) {
                            Map map = (Map)element;
                            tranformed.put(map.get("key"), map.get("value"));
                        }
                        data = tranformed;
                    } else {
                        data = new JaxbListAdapter().unmarshal(wrapper);
                    }
                    return data;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result;
        }

        private Object[] toArray(Object element) {
            if (element != null && element instanceof Collection) {
                return ((Collection)element).toArray();
            }
            return new Object[0];
        }

        private boolean isFullyQualifiedClassname(String classname) {
            if (!classname.contains(".")) {
                return false;
            }
            return this.VALID_JAVA_IDENTIFIER.matcher(classname).matches();
        }
    }

    class WrappingObjectSerializer
    extends JsonSerializer<Object> {
        private ObjectMapper customObjectMapper;

        public WrappingObjectSerializer(ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String className = value.getClass().getName();
            String json = this.customObjectMapper.writeValueAsString(value);
            if (!(className.startsWith("java.") || className.startsWith("javax.") || json.contains(className))) {
                json = "{\"" + className + "\":" + json + "}";
            }
            jgen.writeRawValue(json);
        }
    }

    class CustomObjectSerializer
    extends JsonSerializer<Object> {
        private ObjectMapper customObjectMapper;

        public CustomObjectSerializer(ObjectMapper customObjectMapper) {
            this.customObjectMapper = customObjectMapper;
        }

        public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            String json = this.customObjectMapper.writeValueAsString(value);
            jgen.writeRawValue(json);
        }
    }

    class ExtendedJaxbAnnotationIntrospector
    extends JaxbAnnotationIntrospector {
        private List<NamedType> customClasses;
        private ObjectMapper customObjectMapper;

        public ExtendedJaxbAnnotationIntrospector(List<NamedType> customClasses, ObjectMapper anotherCustomObjectMapper) {
            this.customClasses = customClasses;
            this.customObjectMapper = anotherCustomObjectMapper;
        }

        public List<NamedType> findSubtypes(Annotated a) {
            List base = super.findSubtypes(a);
            ArrayList<NamedType> complete = new ArrayList<NamedType>();
            if (base != null) {
                complete.addAll(base);
            }
            if (this.customClasses != null) {
                complete.addAll(this.customClasses);
            }
            return complete;
        }

        public JsonSerializer<?> findSerializer(Annotated am) {
            XmlJavaTypeAdapter adapterInfo = (XmlJavaTypeAdapter)this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
            if (adapterInfo != null && adapterInfo.value().isAssignableFrom(JaxbUnknownAdapter.class)) {
                return new WrappingObjectSerializer(this.customObjectMapper);
            }
            return super.findSerializer(am);
        }

        public JsonDeserializer<?> findDeserializer(Annotated am) {
            return super.findDeserializer(am);
        }
    }
}

