/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.server.api.model.KieContainerResourceFilter;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;

public class KieContainerResourceFilterTest {
    private static final String GROUP_ID = "org.example";
    private static final String ARTIFACT_ID = "project";
    private static final String VERSION = "1.0.0.Final";
    private static final ReleaseId RELEASE_ID = new ReleaseId("org.example", "project", "1.0.0.Final");

    @Test
    public void toURLQueryStringGroupIdOnly() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().releaseId(new ReleaseId(GROUP_ID, null, null)).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"groupId=org.example");
    }

    @Test
    public void toURLQueryStringArtifactIdOnly() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().releaseId(new ReleaseId(null, ARTIFACT_ID, null)).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"artifactId=project");
    }

    @Test
    public void toURLQueryStringVersionOnly() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().releaseId(new ReleaseId(null, null, VERSION)).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"version=1.0.0.Final");
    }

    @Test
    public void toURLQueryStringReleaseIdOnly() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().releaseId(RELEASE_ID).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"groupId=org.example&artifactId=project&version=1.0.0.Final");
    }

    @Test
    public void toURLQueryStringSingleStatus() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().status(KieContainerStatus.STARTED).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"status=STARTED");
    }

    @Test
    public void toURLQueryStringMultipleStatuses() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().statuses(new KieContainerStatus[]{KieContainerStatus.CREATING, KieContainerStatus.STARTED, KieContainerStatus.FAILED}).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"status=CREATING,STARTED,FAILED");
    }

    @Test
    public void toURLQueryStringReleaseIdWithStatus() {
        KieContainerResourceFilter filter = new KieContainerResourceFilter.Builder().releaseId(RELEASE_ID).status(KieContainerStatus.STARTED).build();
        Assertions.assertThat((String)filter.toURLQueryString()).isEqualTo((Object)"groupId=org.example&artifactId=project&version=1.0.0.Final&status=STARTED");
    }
}

