/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model;

import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.objects.NestedLevel1;
import org.kie.server.api.marshalling.objects.NestedLevel2;
import org.kie.server.api.marshalling.objects.NestedLevel3;
import org.kie.server.api.marshalling.objects.Top;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarshallingRoundTripNestedClassesWithAnnotationsTest {
    private static final Logger logger = LoggerFactory.getLogger(MarshallingRoundTripNestedClassesWithAnnotationsTest.class);

    private static Top createTestObject() {
        Top top = new Top();
        NestedLevel3 level3 = new NestedLevel3();
        level3.setName("Anton");
        NestedLevel2 level2 = new NestedLevel2();
        level2.setNestedLevel3(level3);
        NestedLevel1 level1 = new NestedLevel1();
        level1.setNestedLevel2(level2);
        top.setNestedLevel1(level1);
        return top;
    }

    private Set<Class<?>> getCustomClasses() {
        HashSet classes = new HashSet();
        classes.add(Top.class);
        classes.add(NestedLevel3.class);
        classes.add(NestedLevel2.class);
        classes.add(NestedLevel1.class);
        return classes;
    }

    @Test
    public void testJaxb() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesWithAnnotationsTest.createTestObject());
    }

    @Test
    public void testXStream() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesWithAnnotationsTest.createTestObject());
    }

    @Test
    public void testJSON() {
        Marshaller marshaller = MarshallerFactory.getMarshaller(this.getCustomClasses(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)this.getClass().getClassLoader());
        this.verifyMarshallingRoundTrip(marshaller, MarshallingRoundTripNestedClassesWithAnnotationsTest.createTestObject());
    }

    private void verifyMarshallingRoundTrip(Marshaller marshaller, Object inputObject) {
        String rawContent = marshaller.marshall(inputObject);
        logger.info(rawContent);
        Object testObjectAfterMarshallingTurnAround = marshaller.unmarshall(rawContent, inputObject.getClass());
        Assertions.assertThat((Object)testObjectAfterMarshallingTurnAround).isEqualTo(inputObject);
    }
}

