/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.dmn;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.kie.api.builder.Message;
import org.kie.dmn.api.core.DMNMessage;
import org.kie.dmn.api.core.DMNMessageType;
import org.kie.dmn.api.feel.runtime.events.FEELEvent;
import org.kie.internal.builder.InternalMessage;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="dmn-message")
@XStreamAlias(value="dmn-message")
public class DMNMessageKS
implements DMNMessage {
    @XmlElement(name="dmn-message-severity")
    @XStreamAlias(value="dmn-message-severity")
    private DMNMessageSeverityKS severity;
    @XmlElement(name="message")
    @XStreamAlias(value="message")
    private String message;
    @XmlElement(name="message-type")
    @XStreamAlias(value="message-type")
    private DMNMessageType messageType;
    @XmlElement(name="source-id")
    @XStreamAlias(value="source-id")
    private String sourceId;

    public static DMNMessageKS of(DMNMessage value) {
        DMNMessageKS res = new DMNMessageKS();
        res.severity = DMNMessageSeverityKS.of(value.getSeverity());
        res.message = value.getMessage();
        res.messageType = value.getMessageType();
        res.sourceId = value.getSourceId();
        return res;
    }

    public DMNMessage.Severity getSeverity() {
        return this.severity.asSeverity();
    }

    public String getMessage() {
        return this.message;
    }

    public DMNMessageType getMessageType() {
        return this.messageType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public Throwable getException() {
        throw new UnsupportedOperationException();
    }

    public FEELEvent getFeelEvent() {
        throw new UnsupportedOperationException();
    }

    public Object getSourceReference() {
        throw new UnsupportedOperationException();
    }

    public String getKieBaseName() {
        throw new UnsupportedOperationException();
    }

    public InternalMessage setKieBaseName(String kieBaseName) {
        throw new UnsupportedOperationException();
    }

    public long getId() {
        throw new UnsupportedOperationException();
    }

    public String getPath() {
        throw new UnsupportedOperationException();
    }

    public int getLine() {
        throw new UnsupportedOperationException();
    }

    public int getColumn() {
        throw new UnsupportedOperationException();
    }

    public Message.Level getLevel() {
        switch (this.severity) {
            case ERROR: {
                return Message.Level.ERROR;
            }
            case INFO: {
                return Message.Level.INFO;
            }
            case TRACE: {
                return Message.Level.INFO;
            }
            case WARN: {
                return Message.Level.WARNING;
            }
        }
        return Message.Level.ERROR;
    }

    public String getText() {
        StringBuilder sb = new StringBuilder();
        sb.append("DMN: ");
        sb.append(this.message);
        sb.append(" (");
        if (this.getPath() != null) {
            sb.append("resource: ");
            sb.append(this.getPath());
            sb.append(", ");
        }
        if (this.getSourceId() != null) {
            sb.append("DMN id: ");
            sb.append(this.getSourceId());
            sb.append(", ");
        }
        sb.append(this.getMessageType().getDescription());
        sb.append(") ");
        return sb.toString();
    }

    public static enum DMNMessageSeverityKS {
        TRACE,
        INFO,
        WARN,
        ERROR;


        public static DMNMessageSeverityKS of(DMNMessage.Severity value) {
            switch (value) {
                case ERROR: {
                    return ERROR;
                }
                case INFO: {
                    return INFO;
                }
                case TRACE: {
                    return TRACE;
                }
                case WARN: {
                    return WARN;
                }
            }
            return ERROR;
        }

        public DMNMessage.Severity asSeverity() {
            switch (this) {
                case ERROR: {
                    return DMNMessage.Severity.ERROR;
                }
                case INFO: {
                    return DMNMessage.Severity.INFO;
                }
                case TRACE: {
                    return DMNMessage.Severity.TRACE;
                }
                case WARN: {
                    return DMNMessage.Severity.WARN;
                }
            }
            return DMNMessage.Severity.ERROR;
        }
    }
}

