/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.model.instance;

import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="variable-instance")
public class VariableInstance {
    @XmlElement(name="name")
    private String variableName;
    @XmlElement(name="old-value")
    private String oldValue;
    @XmlElement(name="value")
    private String value;
    @XmlElement(name="process-instance-id")
    private Long processInstanceId;
    @XmlElement(name="modification-date")
    private Date date;

    public static Builder builder() {
        return new Builder();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public String getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(String oldValue) {
        this.oldValue = oldValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String toString() {
        return "VariableInstance{variableName='" + this.variableName + '\'' + ", oldValue='" + this.oldValue + '\'' + ", value='" + this.value + '\'' + ", processInstanceId=" + this.processInstanceId + ", date=" + this.date + '}';
    }

    public static class Builder {
        private VariableInstance variableInstance = new VariableInstance();

        public VariableInstance build() {
            return this.variableInstance;
        }

        public Builder name(String name) {
            this.variableInstance.setVariableName(name);
            return this;
        }

        public Builder value(String value) {
            this.variableInstance.setValue(value);
            return this;
        }

        public Builder oldValue(String oldValue) {
            this.variableInstance.setOldValue(oldValue);
            return this;
        }

        public Builder processInstanceId(Long processInstanceId) {
            this.variableInstance.setProcessInstanceId(processInstanceId);
            return this;
        }

        public Builder date(Date date) {
            this.variableInstance.setDate(date == null ? date : new Date(date.getTime()));
            return this;
        }
    }
}

