/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.api.marshalling;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.kie.server.api.marshalling.MarshallingFormat;

public class MarshallingFormatTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void testEmptyMarshallingFormat() {
        this.exception.expectMessage("Invalid marshalling format []");
        MarshallingFormat.fromType((String)"");
    }

    @Test
    public void testNullMarshallingFormat() {
        this.exception.expectMessage("Invalid marshalling format [null]");
        MarshallingFormat.fromType(null);
    }

    @Test
    public void testNonNullEmptyInvalidMarshallingFormat() {
        this.exception.expectMessage("Invalid marshalling format [JAX]");
        MarshallingFormat.fromType((String)"JAX");
    }

    @Test
    public void testExpectedMarshallingFormats() {
        Assert.assertEquals((Object)MarshallingFormat.JSON, (Object)MarshallingFormat.fromType((String)"json"));
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"xml"));
        Assert.assertEquals((Object)MarshallingFormat.XSTREAM, (Object)MarshallingFormat.fromType((String)"xstream"));
        Assert.assertEquals((Object)MarshallingFormat.JSON, (Object)MarshallingFormat.fromType((String)"application/json"));
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"application/xml"));
        Assert.assertEquals((Object)MarshallingFormat.XSTREAM, (Object)MarshallingFormat.fromType((String)"application/xstream"));
    }

    @Test
    public void testMarshallingFormatsWithExtraneousParameters() {
        Assert.assertEquals((Object)MarshallingFormat.JSON, (Object)MarshallingFormat.fromType((String)"application/json;"));
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"application/xml;"));
        Assert.assertEquals((Object)MarshallingFormat.XSTREAM, (Object)MarshallingFormat.fromType((String)"application/xstream;"));
        Assert.assertEquals((Object)MarshallingFormat.JSON, (Object)MarshallingFormat.fromType((String)"application/json;encode="));
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"application/xml;encode=utf-8"));
        Assert.assertEquals((Object)MarshallingFormat.XSTREAM, (Object)MarshallingFormat.fromType((String)"application/xstream;utf-8"));
    }

    @Test
    public void testMarshallingFormatCase() {
        Assert.assertEquals((Object)MarshallingFormat.JSON, (Object)MarshallingFormat.fromType((String)"JSON"));
    }

    @Test
    public void testEdgeCaseWithJaxb() {
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"jaxb"));
        Assert.assertEquals((Object)MarshallingFormat.JAXB, (Object)MarshallingFormat.fromType((String)"JAXB"));
    }

    @Test
    public void testStricttype() {
        Assert.assertTrue((boolean)MarshallingFormat.isStrictType((String)"application/json; strict=true"));
        Assert.assertFalse((boolean)MarshallingFormat.isStrictType((String)"application/xml;strict=false"));
        Assert.assertFalse((boolean)MarshallingFormat.isStrictType((String)"application/json;"));
        Assert.assertFalse((boolean)MarshallingFormat.isStrictType((String)"application/xml;strict="));
    }

    @Test
    public void testMultipleMediaTypeParameters() {
        Assert.assertEquals((Object)"not_null", MarshallingFormat.buildParameters((String)"application/json;fields=not_null;strict=true").get("fields"));
        Assert.assertEquals((Object)"true", MarshallingFormat.buildParameters((String)"application/json;fields=not_null;strict=true").get("strict"));
    }
}

