/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.websocket;

import java.util.function.Consumer;
import org.kie.server.controller.api.model.events.ContainerSpecUpdated;
import org.kie.server.controller.api.model.events.KieServerControllerEvent;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateDeleted;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.client.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketEventHandler
implements Consumer<KieServerControllerEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketEventHandler.class);
    private EventHandler handler;

    public WebSocketEventHandler(EventHandler handler) {
        this.handler = handler;
    }

    @Override
    public void accept(KieServerControllerEvent event) {
        LOGGER.debug("Handling Kie Server Controller event: {}", (Object)event);
        if (event instanceof ServerInstanceConnected) {
            this.handler.onServerInstanceConnected((ServerInstanceConnected)event);
        } else if (event instanceof ServerInstanceDeleted) {
            this.handler.onServerInstanceDeleted((ServerInstanceDeleted)event);
        } else if (event instanceof ServerInstanceDisconnected) {
            this.handler.onServerInstanceDisconnected((ServerInstanceDisconnected)event);
        } else if (event instanceof ServerInstanceUpdated) {
            this.handler.onServerInstanceUpdated((ServerInstanceUpdated)event);
        } else if (event instanceof ServerTemplateDeleted) {
            this.handler.onServerTemplateDeleted((ServerTemplateDeleted)event);
        } else if (event instanceof ServerTemplateUpdated) {
            this.handler.onServerTemplateUpdated((ServerTemplateUpdated)event);
        } else if (event instanceof ContainerSpecUpdated) {
            this.handler.onContainerSpecUpdated((ContainerSpecUpdated)event);
        } else {
            LOGGER.warn("Unable to handle Kie Server Controller event: {}", (Object)event);
        }
    }
}

