/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.client.rest;

import java.util.HashSet;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Response;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingException;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.common.rest.Authenticator;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerKey;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKeyList;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.client.KieServerControllerClient;
import org.kie.server.controller.client.exception.KieServerControllerHTTPClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestKieServerControllerClient
implements KieServerControllerClient {
    private static Logger logger = LoggerFactory.getLogger(RestKieServerControllerClient.class);
    private static final String MANAGEMENT_LAST_URI_PART = "/management/servers";
    private static final String CONTAINERS_LAST_URI_PART = "/containers";
    private static final String RUNTIME_LAST_URI_PART = "/runtime/servers";
    private static final String INSTANCES_LAST_URI_PART = "/instances";
    private static final String MANAGEMENT_URI_PART = "/management/servers/";
    private static final String CONTAINERS_URI_PART = "/containers/";
    private static final String RUNTIME_URI_PART = "/runtime/servers/";
    private static final String INSTANCES_URI_PART = "/instances/";
    private static final String STARTED_STATUS_URI_PART = "/status/started";
    private static final String STOPPED_STATUS_URI_PART = "/status/stopped";
    private static final String ACTIVATED_STATUS_URI_PART = "/status/activated";
    private static final String DEACTIVATED_STATUS_URI_PART = "/status/deactivated";
    private static final String CONFIG_URI_PART = "/config/";
    private String controllerBaseUrl;
    private static final MarshallingFormat DEFAULT_MARSHALLING_FORMAT = MarshallingFormat.JAXB;
    private MarshallingFormat format;
    private Client httpClient;
    protected Marshaller marshaller;

    public RestKieServerControllerClient(String controllerBaseUrl, String login, String password) {
        this(controllerBaseUrl, login, password, DEFAULT_MARSHALLING_FORMAT);
    }

    public RestKieServerControllerClient(String controllerBaseUrl, String login, String password, MarshallingFormat format) {
        this(controllerBaseUrl, login, password, format, null);
    }

    public RestKieServerControllerClient(String controllerBaseUrl, String login, String password, MarshallingFormat format, Configuration configuration) {
        this.controllerBaseUrl = controllerBaseUrl;
        this.httpClient = (Client)(configuration == null ? ClientBuilder.newClient() : ClientBuilder.newClient((Configuration)configuration)).register((Object)new Authenticator(login, password));
        this.setMarshallingFormat(format);
    }

    public ServerTemplate getServerTemplate(String serverTemplateId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId, ServerTemplate.class);
    }

    public void saveContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerSpec.getId(), containerSpec, Object.class);
    }

    public void updateContainerSpec(String serverTemplateId, ContainerSpec containerSpec) {
        this.updateContainerSpec(serverTemplateId, containerSpec.getId(), containerSpec);
    }

    public void updateContainerSpec(String serverTemplateId, String containerId, ContainerSpec containerSpec) {
        this.updateContainerSpec(serverTemplateId, containerId, containerSpec, false);
    }

    public void updateContainerSpec(String serverTemplateId, String containerId, ContainerSpec containerSpec, Boolean resetBeforeUpdate) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + "?" + "resetBeforeUpdate" + "=" + resetBeforeUpdate, containerSpec, Object.class);
    }

    public void saveServerTemplate(ServerTemplate serverTemplate) {
        this.makePutRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplate.getId(), serverTemplate, Object.class);
    }

    public void deleteServerTemplate(String serverTemplateId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId);
    }

    public ContainerSpec getContainerInfo(String serverTemplateId, String containerId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId, ContainerSpec.class);
    }

    public void deleteContainerSpec(String serverTemplateId, String containerId) {
        this.makeDeleteRequest(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId);
    }

    public ServerTemplateList listServerTemplates() {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_LAST_URI_PART, ServerTemplateList.class);
    }

    public ContainerSpecList listContainerSpec(String serverTemplateId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_LAST_URI_PART, ContainerSpecList.class);
    }

    public void startContainer(ContainerSpecKey containerSpecKey) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + containerSpecKey.getServerTemplateKey().getId() + CONTAINERS_URI_PART + containerSpecKey.getId() + STARTED_STATUS_URI_PART, "", null);
    }

    public void stopContainer(ContainerSpecKey containerSpecKey) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + containerSpecKey.getServerTemplateKey().getId() + CONTAINERS_URI_PART + containerSpecKey.getId() + STOPPED_STATUS_URI_PART, "", null);
    }

    public void activateContainer(ContainerSpecKey containerSpecKey) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + containerSpecKey.getServerTemplateKey().getId() + CONTAINERS_URI_PART + containerSpecKey.getId() + ACTIVATED_STATUS_URI_PART, "", null);
    }

    public void deactivateContainer(ContainerSpecKey containerSpecKey) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + containerSpecKey.getServerTemplateKey().getId() + CONTAINERS_URI_PART + containerSpecKey.getId() + DEACTIVATED_STATUS_URI_PART, "", null);
    }

    public void updateContainerConfig(String serverTemplateId, String containerId, Capability capability, ContainerConfig config) {
        this.makePostRequestAndCreateCustomResponse(this.controllerBaseUrl + MANAGEMENT_URI_PART + serverTemplateId + CONTAINERS_URI_PART + containerId + CONFIG_URI_PART + capability.toString(), config, Object.class);
    }

    private <T> T throwUnsupportedException() {
        throw new UnsupportedOperationException("Not supported for REST implementation");
    }

    public ServerTemplateKeyList listServerTemplateKeys() {
        return (ServerTemplateKeyList)this.throwUnsupportedException();
    }

    public void copyServerTemplate(String serverTemplateId, String newServerTemplateId, String newServerTemplateName) {
        this.throwUnsupportedException();
    }

    public void updateServerTemplateConfig(String serverTemplateId, Capability capability, ServerConfig serverTemplateConfig) {
        this.throwUnsupportedException();
    }

    public void scanNow(ContainerSpecKey containerSpecKey) {
        this.throwUnsupportedException();
    }

    public void startScanner(ContainerSpecKey containerSpecKey, Long interval) {
        this.throwUnsupportedException();
    }

    public ServerInstanceKeyList getServerInstances(String serverTemplateId) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + RUNTIME_URI_PART + serverTemplateId + INSTANCES_URI_PART, ServerInstanceKeyList.class);
    }

    public void stopScanner(ContainerSpecKey containerSpecKey) {
        this.throwUnsupportedException();
    }

    public ContainerList getContainers(ServerInstanceKey serverInstanceKey) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + RUNTIME_URI_PART + serverInstanceKey.getServerTemplateId() + INSTANCES_URI_PART + serverInstanceKey.getServerInstanceId() + CONTAINERS_URI_PART, ContainerList.class);
    }

    public ContainerList getContainers(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        return this.makeGetRequestAndCreateCustomResponse(this.controllerBaseUrl + RUNTIME_URI_PART + serverTemplate.getId() + CONTAINERS_URI_PART + containerSpec.getId() + INSTANCES_LAST_URI_PART, ContainerList.class);
    }

    public void upgradeContainer(ContainerSpecKey containerSpecKey, ReleaseId releaseId) {
        this.throwUnsupportedException();
    }

    public void deleteServerInstance(ServerInstanceKey serverInstanceKey) {
        this.throwUnsupportedException();
    }

    private <T> T makeGetRequestAndCreateCustomResponse(String uri, Class<T> resultType) {
        WebTarget clientRequest = this.httpClient.target(uri);
        try (Response response = clientRequest.request(new String[]{this.getMediaType(this.format)}).get();){
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                T t = this.deserialize(response, resultType);
                return t;
            }
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDeleteRequest(String uri) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).delete();
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        try {
            if (response.getStatus() != Response.Status.NO_CONTENT.getStatusCode()) {
                throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
            }
        }
        finally {
            response.close();
        }
    }

    private <T> T makePutRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).put(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        try {
            if (response.getStatus() == Response.Status.CREATED.getStatusCode()) {
                T t = this.deserialize(response, resultType);
                return t;
            }
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
        finally {
            response.close();
        }
    }

    private <T> T makePostRequestAndCreateCustomResponse(String uri, Object bodyObject, Class<T> resultType) {
        Response response;
        WebTarget clientRequest = this.httpClient.target(uri);
        try {
            Entity requestEntity = Entity.entity((Object)this.serialize(bodyObject), (String)this.getMediaType(this.format));
            response = clientRequest.request(new String[]{this.getMediaType(this.format)}).post(requestEntity);
        }
        catch (Exception e) {
            throw this.createExceptionForUnexpectedFailure(clientRequest, e);
        }
        try {
            if (response.getStatus() == Response.Status.CREATED.getStatusCode() || response.getStatus() == Response.Status.OK.getStatusCode()) {
                T t = this.deserialize(response, resultType);
                return t;
            }
            throw this.createExceptionForUnexpectedResponseCode(clientRequest, response);
        }
        finally {
            response.close();
        }
    }

    private RuntimeException createExceptionForUnexpectedResponseCode(WebTarget request, Response response) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Unexpected HTTP response code when requesting URI '");
        stringBuffer.append(this.getClientRequestUri(request));
        stringBuffer.append("'! Response code: ");
        stringBuffer.append(response.getStatus());
        try {
            String responseEntity = (String)response.readEntity(String.class);
            stringBuffer.append(" Response message: ");
            stringBuffer.append(responseEntity);
        }
        catch (IllegalStateException e) {
            logger.warn("Error trying to read response entity: {}", (Object)e.getMessage(), (Object)e);
        }
        logger.debug(stringBuffer.toString());
        return new KieServerControllerHTTPClientException(response.getStatus(), stringBuffer.toString());
    }

    private RuntimeException createExceptionForUnexpectedFailure(WebTarget request, Exception e) {
        String summaryMessage = "Unexpected exception when requesting URI '" + this.getClientRequestUri(request) + "'!";
        logger.debug(summaryMessage);
        return new RuntimeException(summaryMessage, e);
    }

    private String getClientRequestUri(WebTarget clientRequest) {
        try {
            return clientRequest.getUri().toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Malformed client URL was specified!", e);
        }
    }

    @Override
    public void close() {
        try {
            this.httpClient.close();
        }
        catch (Exception e) {
            logger.error("Exception thrown while closing resources!", (Throwable)e);
        }
    }

    public MarshallingFormat getMarshallingFormat() {
        return this.format;
    }

    public void setMarshallingFormat(MarshallingFormat format) {
        this.format = format;
        HashSet<Class> controllerClasses = new HashSet<Class>();
        controllerClasses.add(KieServerInstance.class);
        controllerClasses.add(KieServerInstanceList.class);
        controllerClasses.add(KieServerInstanceInfo.class);
        controllerClasses.add(KieServerSetup.class);
        controllerClasses.add(KieServerStatus.class);
        controllerClasses.add(ServerInstance.class);
        controllerClasses.add(ServerInstanceKey.class);
        controllerClasses.add(ServerInstanceKeyList.class);
        controllerClasses.add(ServerTemplate.class);
        controllerClasses.add(ServerTemplateKey.class);
        controllerClasses.add(ServerConfig.class);
        controllerClasses.add(RuleConfig.class);
        controllerClasses.add(ProcessConfig.class);
        controllerClasses.add(ContainerSpec.class);
        controllerClasses.add(ContainerSpecKey.class);
        controllerClasses.add(Container.class);
        controllerClasses.add(ContainerList.class);
        controllerClasses.add(ContainerKey.class);
        controllerClasses.add(ServerTemplateList.class);
        controllerClasses.add(ContainerSpecList.class);
        switch (format) {
            case JAXB: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)RestKieServerControllerClient.class.getClassLoader());
                break;
            }
            case JSON: {
                this.marshaller = MarshallerFactory.getMarshaller(null, (MarshallingFormat)format, (ClassLoader)RestKieServerControllerClient.class.getClassLoader());
                break;
            }
            default: {
                this.marshaller = MarshallerFactory.getMarshaller(controllerClasses, (MarshallingFormat)format, (ClassLoader)RestKieServerControllerClient.class.getClassLoader());
            }
        }
    }

    private String getMediaType(MarshallingFormat format) {
        switch (format) {
            case JAXB: {
                return "application/xml";
            }
            case JSON: {
                return "application/json";
            }
        }
        return "application/xml";
    }

    protected String serialize(Object object) {
        if (object == null) {
            return "";
        }
        try {
            return this.marshaller.marshall(object);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while serializing request data!", e);
        }
    }

    protected <T> T deserialize(Response response, Class<T> type) {
        try {
            if (type == null) {
                return null;
            }
            String content = (String)response.readEntity(String.class);
            logger.debug("About to deserialize content: \n '{}' \n into type: '{}'", (Object)content, type);
            if (content == null || content.isEmpty()) {
                return null;
            }
            return this.deserialize(content, type);
        }
        catch (MarshallingException e) {
            throw new RuntimeException("Error while deserializing data received from server!", e);
        }
    }

    protected <T> T deserialize(String content, Class<T> type) {
        return (T)this.marshaller.unmarshall(content, type);
    }
}

