/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerControllerAdmin;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.api.storage.KieServerStorageAware;
import org.kie.server.controller.impl.storage.InMemoryKieServerControllerStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerControllerAdminImpl
implements KieServerControllerAdmin,
KieServerStorageAware {
    private static final Logger logger = LoggerFactory.getLogger(KieServerControllerAdminImpl.class);
    private KieServerControllerStorage storage = InMemoryKieServerControllerStorage.getInstance();

    public KieServerInstance addKieServerInstance(KieServerInfo kieServerInfo) throws KieServerControllerException {
        KieServerInstance kieServerInstance = this.storage.load(kieServerInfo.getServerId());
        if (kieServerInstance != null) {
            throw new KieServerControllerException("KieServerInstance is already registered with id: " + kieServerInfo.getServerId());
        }
        kieServerInstance = new KieServerInstance();
        kieServerInstance.setIdentifier(kieServerInfo.getServerId());
        kieServerInstance.setVersion(kieServerInfo.getVersion());
        kieServerInstance.setName(kieServerInfo.getName());
        kieServerInstance.setKieServerSetup(new KieServerSetup());
        kieServerInstance.setStatus(KieServerStatus.UP);
        kieServerInstance.setManagedInstances(new HashSet());
        if (kieServerInfo.getLocation() != null && !kieServerInfo.getLocation().isEmpty()) {
            KieServerInstanceInfo instanceInfo = new KieServerInstanceInfo(kieServerInfo.getLocation(), KieServerStatus.UP, kieServerInfo.getCapabilities());
            kieServerInstance.getManagedInstances().add(instanceInfo);
        }
        this.storage.store(kieServerInstance);
        return kieServerInstance;
    }

    public KieServerInstance removeKieServerInstance(String identifier) throws KieServerControllerException {
        KieServerInstance kieServerInstance = this.storage.load(identifier);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + identifier);
        }
        return this.storage.delete(identifier);
    }

    public List<KieServerInstance> listKieServerInstances() {
        return this.storage.load();
    }

    public KieServerInstance getKieServerInstance(String identifier) throws KieServerControllerException {
        KieServerInstance kieServerInstance = this.storage.load(identifier);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + identifier);
        }
        return kieServerInstance;
    }

    public KieContainerResource createContainer(String id, String containerId, KieContainerResource container) {
        KieServerInstance kieServerInstance = this.storage.load(id);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        KieContainerResource kieContainerResource = this.findKieContainer(kieServerInstance, containerId);
        if (kieContainerResource != null) {
            throw new KieServerControllerException("KieContainer already exists with id: " + id);
        }
        HashSet<KieContainerResource> containers = kieServerInstance.getKieServerSetup().getContainers();
        if (containers == null) {
            containers = new HashSet<KieContainerResource>();
            kieServerInstance.getKieServerSetup().setContainers(containers);
        }
        containers.add(container);
        container.setStatus(KieContainerStatus.STOPPED);
        return container;
    }

    public void startContainer(String id, String containerId) {
        KieServerInstance kieServerInstance = this.storage.load(id);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        KieContainerResource kieContainerResource = this.findKieContainer(kieServerInstance, containerId);
        if (kieContainerResource == null) {
            throw new KieServerControllerException("KieContainer not found with id: " + id);
        }
        kieContainerResource.setStatus(KieContainerStatus.STARTED);
        this.storage.update(kieServerInstance);
        this.notifyKieServersOnCreateContainer(kieServerInstance, kieContainerResource);
    }

    public void stopContainer(String id, String containerId) {
        KieServerInstance kieServerInstance = this.storage.load(id);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        KieContainerResource kieContainerResource = this.findKieContainer(kieServerInstance, containerId);
        if (kieContainerResource == null) {
            throw new KieServerControllerException("KieContainer not found with id: " + id);
        }
        kieContainerResource.setStatus(KieContainerStatus.STOPPED);
        this.storage.update(kieServerInstance);
        this.notifyKieServersOnDeleteContainer(kieServerInstance, containerId);
    }

    public void deleteContainer(String id, String containerId) {
        KieServerInstance kieServerInstance = this.storage.load(id);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        Set containers = kieServerInstance.getKieServerSetup().getContainers();
        if (containers != null) {
            boolean removed = false;
            Iterator iterator = containers.iterator();
            while (iterator.hasNext()) {
                if (!((KieContainerResource)iterator.next()).getContainerId().equals(containerId)) continue;
                iterator.remove();
                removed = true;
                break;
            }
            if (removed) {
                kieServerInstance.getKieServerSetup().setContainers(containers);
                this.storage.update(kieServerInstance);
                this.notifyKieServersOnDeleteContainer(kieServerInstance, containerId);
            } else {
                throw new KieServerControllerException("KieContainer not found with id: " + id);
            }
        }
    }

    public KieContainerResource getContainer(String id, String containerId) {
        KieServerInstance kieServerInstance = this.storage.load(id);
        if (kieServerInstance == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        Set containers = kieServerInstance.getKieServerSetup().getContainers();
        if (containers != null) {
            for (KieContainerResource containerResource : containers) {
                if (!containerResource.getContainerId().equals(containerId)) continue;
                return containerResource;
            }
        }
        throw new KieServerControllerException("Container not found with id: " + containerId + " within kie server with id " + id);
    }

    public void setStorage(KieServerControllerStorage storage) {
        this.storage = storage;
    }

    public KieServerControllerStorage getStorage() {
        return this.storage;
    }

    public abstract void notifyKieServersOnCreateContainer(KieServerInstance var1, KieContainerResource var2);

    public abstract void notifyKieServersOnDeleteContainer(KieServerInstance var1, String var2);

    protected KieContainerResource findKieContainer(KieServerInstance kieServerInstance, String containerId) {
        Set containers = kieServerInstance.getKieServerSetup().getContainers();
        if (containers != null) {
            for (KieContainerResource containerResource : containers) {
                if (!containerResource.getContainerId().equals(containerId)) continue;
                return containerResource;
            }
        }
        return null;
    }
}

