/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerControllerAdmin;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public abstract class KieServerControllerAdminImpl
implements KieServerControllerAdmin {
    private static final Logger logger = LoggerFactory.getLogger(KieServerControllerAdminImpl.class);
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();

    public KieServerInstance addKieServerInstance(KieServerInfo kieServerInfo) throws KieServerControllerException {
        ServerTemplate serverTemplate = this.templateStorage.load(kieServerInfo.getServerId());
        if (serverTemplate != null) {
            throw new KieServerControllerException("KieServerInstance is already registered with id: " + kieServerInfo.getServerId());
        }
        KieServerInstance kieServerInstance = new KieServerInstance(kieServerInfo.getServerId(), kieServerInfo.getName(), kieServerInfo.getVersion(), new HashSet(), KieServerStatus.UP, new KieServerSetup());
        if (kieServerInfo.getLocation() != null && !kieServerInfo.getLocation().isEmpty()) {
            KieServerInstanceInfo instanceInfo = new KieServerInstanceInfo(kieServerInfo.getLocation(), KieServerStatus.UP, kieServerInfo.getCapabilities());
            kieServerInstance.getManagedInstances().add(instanceInfo);
        }
        serverTemplate = new ServerTemplate(kieServerInfo.getServerId(), kieServerInfo.getName(), (Collection)kieServerInfo.getCapabilities(), new HashMap(), new ArrayList());
        if (kieServerInfo.getLocation() != null && !kieServerInfo.getLocation().isEmpty()) {
            serverTemplate.addServerInstance(ModelFactory.newServerInstanceKey((String)serverTemplate.getId(), (String)kieServerInfo.getLocation()));
        }
        this.templateStorage.store(serverTemplate);
        return kieServerInstance;
    }

    public KieServerInstance removeKieServerInstance(String identifier) throws KieServerControllerException {
        if (!this.templateStorage.exists(identifier)) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + identifier);
        }
        this.templateStorage.delete(identifier);
        return null;
    }

    public List<KieServerInstance> listKieServerInstances() {
        ArrayList<KieServerInstance> serverInstances = new ArrayList<KieServerInstance>();
        List templates = this.templateStorage.load();
        for (ServerTemplate serverTemplate : templates) {
            KieServerInstance kieServerInstance = this.forServerTemplate(serverTemplate);
            serverInstances.add(kieServerInstance);
        }
        return serverInstances;
    }

    public KieServerInstance getKieServerInstance(String identifier) throws KieServerControllerException {
        ServerTemplate serverTemplate = this.templateStorage.load(identifier);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + identifier);
        }
        KieServerInstance kieServerInstance = this.forServerTemplate(serverTemplate);
        return kieServerInstance;
    }

    public KieContainerResource createContainer(String id, String containerId, KieContainerResource container) {
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec != null) {
            throw new KieServerControllerException("KieContainer already exists with id: " + id);
        }
        containerSpec = new ContainerSpec(container.getContainerId(), container.getContainerId(), (ServerTemplateKey)serverTemplate, container.getReleaseId(), KieContainerStatus.STOPPED, new HashMap());
        if (container.getScanner() != null) {
            RuleConfig ruleConfig = new RuleConfig();
            ruleConfig.setPollInterval(container.getScanner().getPollInterval());
            ruleConfig.setScannerStatus(container.getScanner().getStatus());
            containerSpec.addConfig(Capability.RULE, (ContainerConfig)ruleConfig);
        }
        serverTemplate.addContainerSpec(containerSpec);
        this.templateStorage.update(serverTemplate);
        container.setStatus(KieContainerStatus.STOPPED);
        return container;
    }

    public void startContainer(String id, String containerId) {
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec == null) {
            throw new KieServerControllerException("KieContainer not found with id: " + id);
        }
        containerSpec.setStatus(KieContainerStatus.STARTED);
        this.templateStorage.update(serverTemplate);
        KieServerInstance kieServerInstance = this.forServerTemplate(serverTemplate);
        KieContainerResource kieContainerResource = this.forContainerSpec(containerSpec);
        this.notifyKieServersOnCreateContainer(kieServerInstance, kieContainerResource);
    }

    public void stopContainer(String id, String containerId) {
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec == null) {
            throw new KieServerControllerException("KieContainer not found with id: " + id);
        }
        containerSpec.setStatus(KieContainerStatus.STOPPED);
        this.templateStorage.update(serverTemplate);
        KieServerInstance kieServerInstance = this.forServerTemplate(serverTemplate);
        this.notifyKieServersOnDeleteContainer(kieServerInstance, containerId);
    }

    public void deleteContainer(String id, String containerId) {
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec == null) {
            throw new KieServerControllerException("KieContainer not found with id: " + id);
        }
        serverTemplate.deleteContainerSpec(containerId);
        this.templateStorage.update(serverTemplate);
        KieServerInstance kieServerInstance = this.forServerTemplate(serverTemplate);
        this.notifyKieServersOnDeleteContainer(kieServerInstance, containerId);
    }

    public KieContainerResource getContainer(String id, String containerId) {
        ServerTemplate serverTemplate = this.templateStorage.load(id);
        if (serverTemplate == null) {
            throw new KieServerControllerException("KieServerInstance not found with id: " + id);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
        if (containerSpec == null) {
            throw new KieServerControllerException("Container not found with id: " + containerId + " within kie server with id " + id);
        }
        KieContainerResource containerResource = this.forContainerSpec(containerSpec);
        return containerResource;
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public abstract void notifyKieServersOnCreateContainer(KieServerInstance var1, KieContainerResource var2);

    public abstract void notifyKieServersOnDeleteContainer(KieServerInstance var1, String var2);

    protected KieServerInstance forServerTemplate(ServerTemplate serverTemplate) {
        KieServerInstance kieServerInstance = new KieServerInstance();
        kieServerInstance.setIdentifier(serverTemplate.getId());
        kieServerInstance.setVersion("");
        kieServerInstance.setName(serverTemplate.getName());
        kieServerInstance.setKieServerSetup(new KieServerSetup());
        kieServerInstance.setStatus(KieServerStatus.DOWN);
        kieServerInstance.setManagedInstances(new HashSet());
        if (serverTemplate.getServerInstanceKeys() != null) {
            for (ServerInstanceKey instanceKey : serverTemplate.getServerInstanceKeys()) {
                KieServerInstanceInfo instanceInfo = new KieServerInstanceInfo(instanceKey.getUrl(), KieServerStatus.UP, serverTemplate.getCapabilities());
                kieServerInstance.getManagedInstances().add(instanceInfo);
            }
        }
        return kieServerInstance;
    }

    protected KieContainerResource forContainerSpec(ContainerSpec containerSpec) {
        KieContainerResource containerResource = new KieContainerResource();
        containerResource.setContainerId(containerSpec.getId());
        containerResource.setReleaseId(containerSpec.getReleasedId());
        containerResource.setStatus(containerSpec.getStatus());
        ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
        if (containerConfig != null) {
            RuleConfig ruleConfig = (RuleConfig)containerConfig;
            KieScannerResource scannerResource = new KieScannerResource();
            scannerResource.setPollInterval(ruleConfig.getPollInterval());
            scannerResource.setStatus(ruleConfig.getScannerStatus());
            containerResource.setScanner(scannerResource);
        }
        return containerResource;
    }
}

