/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.storage.KieServerControllerStorage;

public class InMemoryKieServerControllerStorage
implements KieServerControllerStorage {
    private static InMemoryKieServerControllerStorage INSTANCE = new InMemoryKieServerControllerStorage();
    private Map<String, KieServerInstance> store = new ConcurrentHashMap<String, KieServerInstance>();

    private InMemoryKieServerControllerStorage() {
    }

    public static InMemoryKieServerControllerStorage getInstance() {
        return INSTANCE;
    }

    public KieServerInstance store(KieServerInstance kieServerInstance) {
        this.store.put(kieServerInstance.getIdentifier(), kieServerInstance);
        return kieServerInstance;
    }

    public List<KieServerInstance> load() {
        return new ArrayList<KieServerInstance>(this.store.values());
    }

    public KieServerInstance load(String identifier) {
        return this.store.get(identifier);
    }

    public KieServerInstance update(KieServerInstance kieServerInstance) {
        this.store.put(kieServerInstance.getIdentifier(), kieServerInstance);
        return kieServerInstance;
    }

    public KieServerInstance delete(String identifier) {
        return this.store.remove(identifier);
    }
}

