/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import com.thoughtworks.xstream.io.StreamException;
import java.io.EOFException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.marshalling.xstream.XStreamMarshaller;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedKieServerTemplateStorage
implements KieServerTemplateStorage {
    private static FileBasedKieServerTemplateStorage INSTANCE;
    public static final String SERVER_TEMPLATE_FILE_NAME_PROP = "org.kie.server.controller.templatefile";
    public static final String DEFAULT_SERVER_TEMPLATE_FILENAME;
    private static Logger logger;
    private Map<String, ServerTemplate> templateMap = new ConcurrentHashMap<String, ServerTemplate>();
    private Map<String, ServerTemplateKey> templateKeyMap = new ConcurrentHashMap<String, ServerTemplateKey>();
    private String templatesLocation;
    private Marshaller templateMarshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.XSTREAM, (ClassLoader)ServerTemplate.class.getClassLoader());

    public static synchronized FileBasedKieServerTemplateStorage getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FileBasedKieServerTemplateStorage();
        }
        return INSTANCE;
    }

    public static synchronized FileBasedKieServerTemplateStorage getInstance(String templatesLocation) {
        if (INSTANCE == null) {
            INSTANCE = new FileBasedKieServerTemplateStorage(templatesLocation);
        }
        return INSTANCE;
    }

    protected FileBasedKieServerTemplateStorage() {
        this.init(null);
    }

    protected FileBasedKieServerTemplateStorage(String templatesLocation) {
        this.init(templatesLocation);
    }

    protected synchronized void init(String templatesLocation) {
        this.templateMap = new ConcurrentHashMap<String, ServerTemplate>();
        this.templateKeyMap = new ConcurrentHashMap<String, ServerTemplateKey>();
        this.templatesLocation = templatesLocation != null && !templatesLocation.trim().isEmpty() ? templatesLocation : System.getProperty(SERVER_TEMPLATE_FILE_NAME_PROP, DEFAULT_SERVER_TEMPLATE_FILENAME);
        this.loadTemplateMapsFromFile();
    }

    private synchronized void writeTemplateMap() {
        try (FileWriter writer = new FileWriter(this.templatesLocation);){
            ((XStreamMarshaller)this.templateMarshaller).getXstream().toXML(new ArrayList<ServerTemplate>(this.templateMap.values()), (Writer)writer);
        }
        catch (Throwable e) {
            logger.error("Unable to write template maps for standalone controller", e);
        }
    }

    private synchronized void loadTemplateMapsFromFile() {
        ArrayList templates = null;
        try (FileReader reader = new FileReader(this.templatesLocation);){
            templates = (ArrayList)((XStreamMarshaller)this.templateMarshaller).getXstream().fromXML((Reader)reader);
        }
        catch (StreamException se) {
            if (se.getCause() instanceof EOFException) {
                logger.warn("Unable to read server template maps from file {}. File does not exist or is empty", (Object)this.templatesLocation);
            } else {
                logger.error("Unable to read server template maps from file due to stream error", (Throwable)se);
            }
        }
        catch (Throwable e) {
            logger.error("Unable to read server template maps from file", e);
        }
        if (templates != null && !templates.isEmpty()) {
            templates.forEach(template -> {
                this.templateKeyMap.put(template.getId(), new ServerTemplateKey(template.getId(), template.getName()));
                this.templateMap.put(template.getId(), (ServerTemplate)template);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate store(ServerTemplate serverTemplate) {
        ServerTemplate template = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            template = this.templateMap.put(serverTemplate.getId(), serverTemplate);
            this.writeTemplateMap();
        }
        return template;
    }

    public List<ServerTemplateKey> loadKeys() {
        return new ArrayList<ServerTemplateKey>(this.templateKeyMap.values());
    }

    public ServerTemplateKey getTemplateKey(String id) {
        return this.templateKeyMap.get(id);
    }

    public List<ServerTemplate> load() {
        return new ArrayList<ServerTemplate>(this.templateMap.values());
    }

    public ServerTemplate load(String identifier) {
        return this.templateMap.get(identifier);
    }

    public boolean exists(String identifier) {
        return this.templateMap.containsKey(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate update(ServerTemplate serverTemplate) {
        ServerTemplate updated = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.put(serverTemplate.getId(), new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            updated = this.templateMap.put(serverTemplate.getId(), serverTemplate);
            this.writeTemplateMap();
        }
        return updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerTemplate delete(String identifier) {
        ServerTemplate removed = null;
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.remove(identifier);
            removed = this.templateMap.remove(identifier);
            this.writeTemplateMap();
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTemplateMaps() {
        Map<String, ServerTemplate> map = this.templateMap;
        synchronized (map) {
            this.templateKeyMap.entrySet().clear();
            this.templateMap.entrySet().clear();
        }
    }

    public void reloadTemplateMaps() {
        this.clearTemplateMaps();
        this.loadTemplateMapsFromFile();
    }

    public void setTemplatesLocation(String templatesLocation) {
        this.templatesLocation = templatesLocation;
    }

    public String getTemplatesLocation() {
        return this.templatesLocation;
    }

    public String toString() {
        return "FileBasedKieServerTemplateStorage: { templatesLocation = " + this.templatesLocation + "}";
    }

    static {
        DEFAULT_SERVER_TEMPLATE_FILENAME = System.getProperty("java.io.tmpdir") + System.getProperty("file.separator") + "template_store.xml";
        logger = LoggerFactory.getLogger(FileBasedKieServerTemplateStorage.class);
    }
}

