/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieScannerResource;
import org.kie.server.api.model.KieServerConfig;
import org.kie.server.api.model.KieServerConfigItem;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.KieServerController;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.events.ServerInstanceConnected;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceDisconnected;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.events.ServerTemplateUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.NotificationService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.service.LoggingNotificationService;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerControllerImpl
implements KieServerController {
    private static final Logger logger = LoggerFactory.getLogger(KieServerControllerImpl.class);
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private NotificationService notificationService = LoggingNotificationService.getInstance();

    public synchronized KieServerSetup connect(KieServerInfo serverInfo) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverInfo.getServerId());
        KieServerSetup serverSetup = new KieServerSetup();
        ServerInstanceKey serverInstanceKey = ModelFactory.newServerInstanceKey((String)serverInfo.getServerId(), (String)serverInfo.getLocation());
        ArrayList<Container> containerList = new ArrayList<Container>();
        if (serverTemplate != null) {
            logger.debug("Server id {} know to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            if (!serverTemplate.hasServerInstance(serverInfo.getLocation())) {
                logger.debug("Server instance '{}' not yet registered", (Object)serverInfo.getLocation());
                serverTemplate.addServerInstance(serverInstanceKey);
            }
            this.templateStorage.update(serverTemplate);
            logger.debug("KieServerInstance updated after connect from server {}", (Object)serverInfo.getLocation());
            HashSet<KieContainerResource> containers = new HashSet<KieContainerResource>();
            for (ContainerSpec containerSpec : serverTemplate.getContainersSpec()) {
                KieContainerResource containerResource = new KieContainerResource();
                containerResource.setContainerId(containerSpec.getId());
                containerResource.setContainerAlias(containerSpec.getContainerName());
                containerResource.setReleaseId(containerSpec.getReleasedId());
                containerResource.setStatus(containerSpec.getStatus());
                ContainerConfig containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.RULE);
                if (containerConfig != null) {
                    RuleConfig ruleConfig = (RuleConfig)containerConfig;
                    KieScannerResource scannerResource = new KieScannerResource();
                    scannerResource.setPollInterval(ruleConfig.getPollInterval());
                    scannerResource.setStatus(ruleConfig.getScannerStatus());
                    containerResource.setScanner(scannerResource);
                }
                if ((containerConfig = (ContainerConfig)containerSpec.getConfigs().get(Capability.PROCESS)) != null) {
                    ProcessConfig processConfig = (ProcessConfig)containerConfig;
                    KieServerConfigItem configItem = new KieServerConfigItem();
                    configItem.setType("BPM");
                    configItem.setName("KBase");
                    configItem.setValue(processConfig.getKBase());
                    containerResource.addConfigItem(configItem);
                    configItem = new KieServerConfigItem();
                    configItem.setType("BPM");
                    configItem.setName("KSession");
                    configItem.setValue(processConfig.getKSession());
                    containerResource.addConfigItem(configItem);
                    configItem = new KieServerConfigItem();
                    configItem.setType("BPM");
                    configItem.setName("MergeMode");
                    configItem.setValue(processConfig.getMergeMode());
                    containerResource.addConfigItem(configItem);
                    configItem = new KieServerConfigItem();
                    configItem.setType("BPM");
                    configItem.setName("RuntimeStrategy");
                    configItem.setValue(processConfig.getRuntimeStrategy());
                    containerResource.addConfigItem(configItem);
                }
                containers.add(containerResource);
                containerList.add(new Container(containerSpec.getId(), containerSpec.getContainerName(), serverInstanceKey, new ArrayList(), containerSpec.getReleasedId(), serverInstanceKey.getUrl() + "/containers/" + containerSpec.getId()));
            }
            serverSetup.setContainers(containers);
            KieServerConfig serverConfig = new KieServerConfig();
            for (Map.Entry entry : serverTemplate.getConfigs().entrySet()) {
                KieServerConfigItem configItem = new KieServerConfigItem();
                ServerConfig config = (ServerConfig)entry.getValue();
                configItem.setType(((Capability)entry.getKey()).toString());
                serverConfig.addConfigItem(configItem);
            }
            serverSetup.setServerConfig(serverConfig);
        } else {
            logger.debug("Server id {} unknown to this controller, registering...", (Object)serverInfo.getServerId());
            serverTemplate = new ServerTemplate();
            serverTemplate.setId(serverInfo.getServerId());
            serverTemplate.setName(serverInfo.getName());
            ArrayList<String> capabilities = new ArrayList<String>();
            if (serverInfo.getCapabilities().contains("BRM")) {
                capabilities.add(Capability.RULE.toString());
            }
            if (serverInfo.getCapabilities().contains("BPM")) {
                capabilities.add(Capability.PROCESS.toString());
            }
            if (serverInfo.getCapabilities().contains("BRP")) {
                capabilities.add(Capability.PLANNING.toString());
            }
            serverTemplate.setCapabilities(capabilities);
            serverTemplate.addServerInstance(serverInstanceKey);
            logger.debug("KieServerInstance stored after connect (register) from server {}", (Object)serverInfo.getLocation());
            this.templateStorage.store(serverTemplate);
            this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        }
        logger.info("Server {} connected to controller", (Object)serverInfo.getLocation());
        ServerInstance serverInstance = new ServerInstance();
        serverInstance.setServerName(serverInstanceKey.getServerName());
        serverInstance.setServerTemplateId(serverInstanceKey.getServerTemplateId());
        serverInstance.setServerInstanceId(serverInstanceKey.getServerInstanceId());
        serverInstance.setUrl(serverInstanceKey.getUrl());
        serverInstance.setContainers(containerList);
        this.notifyOnConnect(serverInstance);
        return serverSetup;
    }

    public synchronized void disconnect(KieServerInfo serverInfo) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverInfo.getServerId());
        if (serverTemplate != null) {
            logger.debug("Server id {} known to the controller, checking if given server exists", (Object)serverInfo.getServerId());
            if (serverTemplate != null) {
                logger.info("Server {} disconnected from controller", (Object)serverInfo.getLocation());
                ServerInstanceKey serverInstanceKey = ModelFactory.newServerInstanceKey((String)serverInfo.getServerId(), (String)serverInfo.getLocation());
                serverTemplate.deleteServerInstance(serverInstanceKey.getServerInstanceId());
                this.templateStorage.update(serverTemplate);
                this.notifyOnDisconnect(serverInstanceKey, serverTemplate);
            }
        }
    }

    protected void notifyOnConnect(ServerInstance serverInstance) {
        this.notificationService.notify(new ServerInstanceUpdated(serverInstance));
        this.notificationService.notify(new ServerInstanceConnected(serverInstance));
    }

    protected void notifyOnDisconnect(ServerInstanceKey serverInstanceKey, ServerTemplate serverTemplate) {
        this.notificationService.notify(new ServerInstanceDeleted(serverInstanceKey.getServerInstanceId()));
        this.notificationService.notify(new ServerTemplateUpdated(serverTemplate));
        this.notificationService.notify(new ServerInstanceDisconnected(serverInstanceKey.getServerInstanceId()));
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public NotificationService getNotificationService() {
        return this.notificationService;
    }

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }
}

