/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.Collection;
import java.util.List;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;

public class RuntimeManagementServiceImpl
implements RuntimeManagementService {
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private KieServerInstanceManager kieServerInstanceManager = KieServerInstanceManager.getInstance();

    public Collection<ServerInstanceKey> getServerInstances(String serverTemplateId) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new RuntimeException("No server template found for id " + serverTemplateId);
        }
        return serverTemplate.getServerInstanceKeys();
    }

    public Collection<Container> getContainers(ServerInstanceKey serverInstanceKey) {
        List<Container> containers = this.kieServerInstanceManager.getContainers(serverInstanceKey);
        return containers;
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public KieServerInstanceManager getKieServerInstanceManager() {
        return this.kieServerInstanceManager;
    }

    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        this.kieServerInstanceManager = kieServerInstanceManager;
    }
}

