/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.ModelFactory;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerHealthCheckControllerImpl
extends KieServerControllerImpl {
    private static final String PING_ALIVE_TIMEOUT = "org.kie.controller.ping.alive.timeout";
    private static final String PING_ALIVE_DISABLED = "org.kie.controller.ping.alive.disable";
    private static long PING_INTERVAL;
    private static boolean PING_DISABLED;
    private static final Logger logger;
    private Ping ping;
    private ExecutorService executorService;

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public synchronized void start() {
        if (PING_DISABLED) {
            return;
        }
        logger.info("Starting is alive ping");
        this.ping = new Ping();
        this.executorService.execute(this.ping);
    }

    public synchronized void stop() {
        if (PING_DISABLED) {
            return;
        }
        logger.info("Stopping is alive ping");
        this.ping.stop();
        this.ping = null;
    }

    private List<KieServerInfo> getServerInfoList() {
        ArrayList<KieServerInfo> serversInfo = new ArrayList<KieServerInfo>();
        List templateKeys = this.getTemplateStorage().loadKeys();
        for (ServerTemplateKey templateKey : templateKeys) {
            ServerTemplate template = this.getTemplateStorage().load(templateKey.getId());
            for (ServerInstanceKey serverInstanceKey : template.getServerInstanceKeys()) {
                KieServerInfo serverInfo = new KieServerInfo(template.getId(), template.getName());
                serverInfo.setLocation(serverInstanceKey.getUrl());
                serversInfo.add(serverInfo);
            }
        }
        return serversInfo;
    }

    static {
        logger = LoggerFactory.getLogger(KieServerHealthCheckControllerImpl.class);
        try {
            PING_INTERVAL = Long.parseLong(System.getProperty(PING_ALIVE_TIMEOUT, "5000"));
        }
        catch (NumberFormatException e) {
            logger.warn("The property org.kie.controller.ping.alive.timeout is not a number; Fallback to 5000 ms ping");
            PING_INTERVAL = 5000L;
        }
        try {
            PING_DISABLED = Boolean.parseBoolean(System.getProperty(PING_ALIVE_DISABLED, "false"));
        }
        catch (NumberFormatException e) {
            logger.warn("The property org.kie.controller.ping.alive.disable is not true/false value; Fallback to false");
            PING_DISABLED = false;
        }
    }

    class Ping
    implements Runnable {
        private AtomicBoolean stop = new AtomicBoolean(false);

        Ping() {
        }

        @Override
        public void run() {
            try {
                while (!this.stop.get()) {
                    for (KieServerInfo kieServerInfo : KieServerHealthCheckControllerImpl.this.getServerInfoList()) {
                        ServerInstanceKey serverInstanceKey = ModelFactory.newServerInstanceKey((String)kieServerInfo.getServerId(), (String)kieServerInfo.getLocation());
                        if (!KieServerInstanceManager.getInstance().isAlive(serverInstanceKey)) {
                            logger.debug("ping isAlive " + kieServerInfo.getLocation() + ": KO. disconnected.");
                            KieServerHealthCheckControllerImpl.this.disconnect(kieServerInfo);
                            continue;
                        }
                        logger.debug("ping isAlive " + kieServerInfo.getLocation() + ": OK");
                    }
                    Thread.sleep(PING_INTERVAL);
                }
            }
            catch (InterruptedException e) {
                logger.warn("Rest Kie health check was interrupted");
            }
        }

        public void stop() {
            this.stop.set(true);
        }
    }
}

