/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.client;

import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.CredentialsProvider;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.credentials.EnteredTokenCredentialsProvider;
import org.kie.server.common.KeyStoreHelperUtil;
import org.kie.server.controller.impl.client.KieServicesClientProvider;

public class RestKieServicesClientProvider
implements KieServicesClientProvider {
    @Override
    public boolean supports(String url) {
        return url.toLowerCase().startsWith("http");
    }

    @Override
    public KieServicesClient get(String url) {
        KieServicesConfiguration configuration = KieServicesFactory.newRestConfiguration((String)url, (String)this.getUser(), (String)this.getPassword());
        configuration.setTimeout(this.getTimeout().longValue());
        configuration.setMarshallingFormat(MarshallingFormat.JSON);
        String authToken = this.getToken();
        if (authToken != null && !authToken.isEmpty()) {
            configuration.setCredentialsProvider((CredentialsProvider)new EnteredTokenCredentialsProvider(authToken));
        }
        KieServicesClient kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        return kieServicesClient;
    }

    protected String getUser() {
        return System.getProperty("org.kie.server.user", "kieserver");
    }

    protected String getPassword() {
        return KeyStoreHelperUtil.loadServerPassword();
    }

    protected String getToken() {
        return System.getProperty("org.kie.server.token");
    }

    protected Long getTimeout() {
        try {
            return Long.parseLong(System.getProperty("org.kie.server.controller.timeout", "60000"));
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("An invalid value is specified for system property org.kie.server.controller.timeout", ex);
        }
    }

    @Override
    public Integer getPriority() {
        return 100;
    }
}

