/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.storage;

import java.io.File;
import java.io.FileReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.kie.server.controller.impl.storage.FileBasedKieServerTemplateStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerStorageFileWatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ControllerStorageFileWatcher.class);
    private WatchService watcher;
    private Path toWatch;
    private AtomicBoolean active = new AtomicBoolean(true);
    private String templateFileName;
    private FileBasedKieServerTemplateStorage storage;

    public ControllerStorageFileWatcher(String configFilePath, FileBasedKieServerTemplateStorage storage) {
        this.toWatch = Paths.get(configFilePath, new String[0]);
        this.templateFileName = this.toWatch.toFile().getName();
        this.storage = storage;
        if (!Files.isDirectory(this.toWatch, new LinkOption[0])) {
            this.toWatch = Paths.get(configFilePath, new String[0]).getParent();
        }
        try {
            this.watcher = this.toWatch.getFileSystem().newWatchService();
            log.debug("About to start watching " + this.toWatch.toString());
            this.toWatch.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
        }
        catch (Exception e) {
            log.error("Error when setting up config file watcher :: " + e.getMessage(), (Throwable)e);
            this.active.set(false);
        }
    }

    public void stop() {
        this.active.set(false);
    }

    @Override
    public void run() {
        try {
            while (this.active.get()) {
                WatchKey key = this.watcher.poll(5L, TimeUnit.SECONDS);
                if (key == null) continue;
                for (WatchEvent<?> event : key.pollEvents()) {
                    Path updatedFile = (Path)event.context();
                    File modifiedFile = updatedFile.toFile();
                    if (!modifiedFile.getName().equals(this.templateFileName)) continue;
                    log.debug("Received template file update event, reloading...");
                    try {
                        FileReader reader = new FileReader(new File(this.toWatch.toFile(), this.templateFileName));
                        Throwable throwable = null;
                        try {
                            this.storage.loadTemplateMapsFromFile();
                            log.info("Successfully reloaded server templates from file");
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            reader.close();
                        }
                    }
                    catch (Exception e) {
                        log.error("Unexpected exception while reading updated template file :: " + e.getMessage(), (Throwable)e);
                    }
                }
                key.reset();
            }
        }
        catch (InterruptedException e) {
            log.debug("Interrupted exception received...");
        }
    }
}

