/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.impl.service;

import java.util.List;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.service.RuntimeManagementService;
import org.kie.server.controller.api.storage.KieServerTemplateStorage;
import org.kie.server.controller.impl.KieServerInstanceManager;
import org.kie.server.controller.impl.storage.InMemoryKieServerTemplateStorage;

public class RuntimeManagementServiceImpl
implements RuntimeManagementService {
    private KieServerTemplateStorage templateStorage = InMemoryKieServerTemplateStorage.getInstance();
    private KieServerInstanceManager kieServerInstanceManager = KieServerInstanceManager.getInstance();

    public ServerInstanceKeyList getServerInstances(String serverTemplateId) {
        ServerTemplate serverTemplate = this.getServerTemplate(serverTemplateId);
        return new ServerInstanceKeyList(serverTemplate.getServerInstanceKeys());
    }

    public ContainerList getContainers(ServerTemplate serverTemplate, ContainerSpec containerSpec) {
        return this.getServerTemplateContainers(serverTemplate.getId(), containerSpec.getId());
    }

    protected ContainerList getServerTemplateContainers(String serverTemplateId, String containerSpecId) {
        ServerTemplate serverTemplate = this.getServerTemplate(serverTemplateId);
        if (!serverTemplate.hasContainerSpec(containerSpecId)) {
            throw new KieServerControllerIllegalArgumentException("Server template with id " + serverTemplateId + " has no container with id " + containerSpecId);
        }
        ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerSpecId);
        List<Container> containers = this.kieServerInstanceManager.getContainers(serverTemplate, containerSpec);
        return new ContainerList(containers);
    }

    protected ServerTemplate getServerTemplate(String serverTemplateId) {
        ServerTemplate serverTemplate = this.templateStorage.load(serverTemplateId);
        if (serverTemplate == null) {
            throw new KieServerControllerIllegalArgumentException("No server template found for id " + serverTemplateId);
        }
        return serverTemplate;
    }

    protected ContainerList getServerInstanceContainers(String serverTemplateId, String serverInstanceId) {
        ServerTemplate serverTemplate = this.getServerTemplate(serverTemplateId);
        if (!serverTemplate.hasServerInstanceId(serverInstanceId)) {
            throw new KieServerControllerIllegalArgumentException("Server template with id " + serverTemplateId + " has no instance with id " + serverInstanceId);
        }
        ServerInstanceKey serverInstanceKey = serverTemplate.getServerInstance(serverInstanceId);
        List<Container> containers = this.kieServerInstanceManager.getContainers(serverInstanceKey);
        return new ContainerList(containers);
    }

    public ContainerList getContainers(ServerInstanceKey serverInstanceKey) {
        return this.getServerInstanceContainers(serverInstanceKey.getServerTemplateId(), serverInstanceKey.getServerInstanceId());
    }

    public KieServerTemplateStorage getTemplateStorage() {
        return this.templateStorage;
    }

    public void setTemplateStorage(KieServerTemplateStorage templateStorage) {
        this.templateStorage = templateStorage;
    }

    public KieServerInstanceManager getKieServerInstanceManager() {
        return this.kieServerInstanceManager;
    }

    public void setKieServerInstanceManager(KieServerInstanceManager kieServerInstanceManager) {
        this.kieServerInstanceManager = kieServerInstanceManager;
    }
}

