/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;

@Mojo(name="get-container", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=false)
public class GetContainerMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=true)
    protected String templateId;
    @Parameter(property="kie-ctrl.container")
    protected String container;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        if (this.container == null && this.project == null) {
            throw new MojoFailureException("Unable to find container name");
        }
        if (this.container == null) {
            this.container = this.project.getGroupId() + ":" + this.project.getArtifactId() + ":" + this.project.getVersion();
        }
        this.getLog().info((CharSequence)("Container: " + this.container));
        ContainerSpec containerSpec = this.kieControllerGateway.getContainer(this.templateId, this.container);
        LogHelper.logContainer(this.getLog(), containerSpec);
    }
}

