/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.plugin;

import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.builder.ContainerBuilder;
import org.kie.server.controller.log.LogHelper;
import org.kie.server.controller.plugin.KieControllerMojo;
import org.kie.server.gateway.KieServerGateway;

@Mojo(name="deploy-container", defaultPhase=LifecyclePhase.DEPLOY, threadSafe=true, requiresProject=true)
public class DeployContainerMojo
extends KieControllerMojo {
    @Parameter(property="kie-ctrl.template-id", required=true)
    protected String templateId;
    @Parameter(property="kie-ctrl.template-name")
    private String templateName;
    @Parameter(property="kie-ctrl.container")
    protected String container;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="kie-ctrl.runtime-strategy")
    private String runtimeStrategy;
    @Parameter(property="kie-ctrl.kbase")
    private String kbase;
    @Parameter(property="kie-ctrl.ksession")
    private String ksession;
    @Parameter(property="kie-ctrl.mergeMode")
    private String mergeMode;
    @Parameter(property="kie-ctrl.pollInterval")
    private Long pollInterval;
    @Parameter(property="kie-ctrl.scannerStatus")
    private String scannerStatus;
    @Parameter(property="kie-ctrl.username", required=true, readonly=true)
    private String username;
    @Parameter(property="kie-ctrl.password", required=true, readonly=true)
    private String password;
    @Parameter(property="kie-ctrl.verify-server-wait-time", defaultValue="1000")
    private Integer verifyServerWaitTime;
    @Parameter(property="kie-ctrl.verify-server-max-time", defaultValue="300000")
    private Integer verifyServerMaxTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeCommand() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("Server Template Id: " + this.templateId));
        this.getLog().info((CharSequence)("Server Template Name: " + this.templateName));
        ContainerBuilder containerBuilder = ContainerBuilder.create(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion()).id(this.container).runtimeStrategy(this.runtimeStrategy).kbase(this.kbase).ksession(this.ksession).mergeMode(this.mergeMode).pollInterval(this.pollInterval).scannerStatus(this.scannerStatus);
        ContainerSpec containerSpec = containerBuilder.build(this.templateId, this.templateName);
        LogHelper.logContainer(this.getLog(), containerSpec);
        this.container = containerBuilder.getId();
        this.kieControllerGateway.createContainer(this.templateId, containerSpec);
        this.getLog().info((CharSequence)("Container " + this.container + " CREATED on server template " + this.templateId));
        this.kieControllerGateway.startContainer(this.templateId, this.container);
        this.getLog().info((CharSequence)("Container " + this.container + " STARTED on server template " + this.templateId));
        ServerTemplate serverTemplate = this.kieControllerGateway.getServerTemplate(this.templateId);
        LogHelper.logServerTemplate(this.getLog(), serverTemplate);
        this.getLog().info((CharSequence)("Verify Server - Wait Time: " + this.verifyServerWaitTime));
        this.getLog().info((CharSequence)("Verify Server - Max Time: " + this.verifyServerMaxTime));
        try (KieServerGateway kieServerGateway = new KieServerGateway(this.username, this.password, this.connectionTimeout, this.socketTimeout);){
            for (ServerInstanceKey server : serverTemplate.getServerInstanceKeys()) {
                this.verifyServerInstance(kieServerGateway, server);
            }
        }
    }

    private void verifyServerInstance(KieServerGateway kieServerGateway, ServerInstanceKey server) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Verifying Server: " + server.getUrl()));
        long timeLimit = System.currentTimeMillis() + (long)this.verifyServerMaxTime.intValue();
        while (System.currentTimeMillis() < timeLimit) {
            try {
                Thread.sleep(this.verifyServerWaitTime.intValue());
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            KieContainerResource container = kieServerGateway.getContainer(server.getUrl(), this.container);
            this.getLog().debug((CharSequence)("Server Response: " + container));
            if (container == null) {
                this.getLog().debug((CharSequence)("Container " + this.container + " is not jet instantiated."));
                continue;
            }
            if (KieContainerStatus.CREATING.equals((Object)container.getStatus())) {
                this.getLog().debug((CharSequence)("Server " + server.getUrl() + " is creating with messages " + LogHelper.read(container.getMessages())));
                continue;
            }
            if (KieContainerStatus.STARTED.equals((Object)container.getStatus())) {
                this.getLog().info((CharSequence)("Server " + server.getUrl() + " started with messages " + LogHelper.read(container.getMessages())));
                return;
            }
            throw new MojoExecutionException(LogHelper.read(container.getMessages()));
        }
        this.getLog().warn((CharSequence)("It is NOT possible to VERIFY if the server " + server.getUrl() + " is STARTED: verify-server-max-time exceeded."));
    }
}

