/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.remote.common.rest.RestEasy960Util;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Wrapped;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;

public class ControllerUtils {
    public static Variant defaultVariant = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).add().build().get(0);
    private static Marshaller jsonMarshaller = MarshallerFactory.getMarshaller((MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)ControllerUtils.class.getClassLoader());
    private static Marshaller jaxbMarshaller = MarshallerFactory.getMarshaller(ControllerUtils.getModelClasses(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)ControllerUtils.class.getClassLoader());

    public static Set<Class<?>> getModelClasses() {
        HashSet modelClasses = new HashSet();
        modelClasses.add(KieServerInstance.class);
        modelClasses.add(KieServerInstanceList.class);
        modelClasses.add(KieServerInstanceInfo.class);
        modelClasses.add(KieServerSetup.class);
        modelClasses.add(KieServerStatus.class);
        return modelClasses;
    }

    public static Response createCorrectVariant(String responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = ControllerUtils.getVariant(headers);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    public static Variant getVariant(HttpHeaders headers) {
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = defaultVariant;
        }
        return v;
    }

    public static String getContentType(HttpHeaders headers) {
        Variant v = ControllerUtils.getVariant(headers);
        String contentType = v.getMediaType().getSubtype();
        List kieContentTypeHeader = headers.getRequestHeader("X-KIE-ContentType");
        if (kieContentTypeHeader != null && !kieContentTypeHeader.isEmpty()) {
            contentType = (String)kieContentTypeHeader.get(0);
        }
        return contentType;
    }

    public static MarshallingFormat getFormat(String descriptor) {
        MarshallingFormat format = MarshallingFormat.fromType((String)descriptor);
        if (format == null) {
            format = MarshallingFormat.valueOf((String)descriptor);
        }
        return format;
    }

    public static <T> T unmarshal(String data, String marshallingFormat, Class<T> unmarshalType) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        MarshallingFormat format = ControllerUtils.getFormat(marshallingFormat);
        Marshaller marshaller = null;
        switch (format) {
            case JAXB: {
                marshaller = jaxbMarshaller;
                break;
            }
            case JSON: {
                marshaller = jsonMarshaller;
                break;
            }
            default: {
                marshaller = jsonMarshaller;
            }
        }
        Object instance = marshaller.unmarshall(data, unmarshalType);
        if (instance instanceof Wrapped) {
            return (T)((Wrapped)instance).unwrap();
        }
        return (T)instance;
    }

    public static String marshal(String marshallingFormat, Object entity) {
        MarshallingFormat format = ControllerUtils.getFormat(marshallingFormat);
        if (format == null) {
            throw new IllegalArgumentException("Unknown marshalling format " + marshallingFormat);
        }
        Marshaller marshaller = null;
        switch (format) {
            case JAXB: {
                marshaller = jaxbMarshaller;
                break;
            }
            case JSON: {
                marshaller = jsonMarshaller;
                break;
            }
            default: {
                marshaller = jsonMarshaller;
            }
        }
        return marshaller.marshall(entity);
    }

    public static String getUser() {
        return System.getProperty("org.kie.server.user", "kieserver");
    }

    public static String getPassword() {
        return System.getProperty("org.kie.server.pwd", "kieserver1!");
    }
}

