/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.marshalling.Marshaller;
import org.kie.server.api.marshalling.MarshallerFactory;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.Wrapped;
import org.kie.server.common.rest.RestEasy960Util;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceInfo;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.model.KieServerStatus;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ContainerKey;
import org.kie.server.controller.api.model.runtime.ServerInstance;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;

public class ControllerUtils {
    private static Marshaller jsonMarshaller = MarshallerFactory.getMarshaller(ControllerUtils.getMinimalModelClasses(), (MarshallingFormat)MarshallingFormat.JSON, (ClassLoader)ControllerUtils.class.getClassLoader());
    private static Marshaller jaxbMarshaller = MarshallerFactory.getMarshaller(ControllerUtils.getModelClasses(), (MarshallingFormat)MarshallingFormat.JAXB, (ClassLoader)ControllerUtils.class.getClassLoader());

    public static Set<Class<?>> getModelClasses() {
        HashSet modelClasses = new HashSet();
        modelClasses.add(KieServerInstance.class);
        modelClasses.add(KieServerInstanceList.class);
        modelClasses.add(KieServerInstanceInfo.class);
        modelClasses.add(KieServerSetup.class);
        modelClasses.add(KieServerStatus.class);
        modelClasses.add(ServerInstance.class);
        modelClasses.add(ServerInstanceKey.class);
        modelClasses.add(ServerTemplate.class);
        modelClasses.add(ServerTemplateKey.class);
        modelClasses.add(ServerConfig.class);
        modelClasses.add(RuleConfig.class);
        modelClasses.add(ProcessConfig.class);
        modelClasses.add(ContainerSpec.class);
        modelClasses.add(ContainerSpecKey.class);
        modelClasses.add(Container.class);
        modelClasses.add(ContainerKey.class);
        modelClasses.add(ServerTemplateList.class);
        modelClasses.add(ContainerSpecList.class);
        return modelClasses;
    }

    public static Set<Class<?>> getMinimalModelClasses() {
        HashSet modelClasses = new HashSet();
        modelClasses.add(RuleConfig.class);
        modelClasses.add(ProcessConfig.class);
        return modelClasses;
    }

    public static Response createCorrectVariant(String responseObj, HttpHeaders headers, Response.Status status) {
        Response.ResponseBuilder responseBuilder = null;
        Variant v = ControllerUtils.getVariant(headers);
        responseBuilder = status != null ? Response.status((Response.Status)status).entity((Object)responseObj).variant(v) : Response.ok((Object)responseObj, (Variant)v);
        return responseBuilder.build();
    }

    public static Variant getVariant(HttpHeaders headers) {
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v == null) {
            v = (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{ControllerUtils.getMediaType(headers)}).add().build().get(0);
        }
        return v;
    }

    public static String getContentType(HttpHeaders headers) {
        List kieContentTypeHeader;
        List contentTypeHeader;
        String contentType = MediaType.APPLICATION_XML_TYPE.toString();
        Variant v = RestEasy960Util.getVariant((HttpHeaders)headers);
        if (v != null) {
            contentType = v.getMediaType().toString();
        }
        if ((contentTypeHeader = headers.getRequestHeader("Content-Type")) != null && !contentTypeHeader.isEmpty()) {
            contentType = (String)contentTypeHeader.get(0);
        }
        if ((kieContentTypeHeader = headers.getRequestHeader("X-KIE-ContentType")) != null && !kieContentTypeHeader.isEmpty()) {
            contentType = (String)kieContentTypeHeader.get(0);
        }
        return contentType;
    }

    public static MediaType getMediaType(HttpHeaders httpHeaders) {
        String contentType = ControllerUtils.getContentType(httpHeaders);
        try {
            return MediaType.valueOf((String)contentType);
        }
        catch (IllegalArgumentException e) {
            MarshallingFormat format = MarshallingFormat.fromType((String)contentType);
            switch (format) {
                case JAXB: {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                case XSTREAM: {
                    return MediaType.APPLICATION_XML_TYPE;
                }
                case JSON: {
                    return MediaType.APPLICATION_JSON_TYPE;
                }
            }
            return MediaType.APPLICATION_XML_TYPE;
        }
    }

    public static MarshallingFormat getFormat(String descriptor) {
        MarshallingFormat format = MarshallingFormat.fromType((String)descriptor);
        if (format == null) {
            format = MarshallingFormat.valueOf((String)descriptor);
        }
        return format;
    }

    public static <T> T unmarshal(String data, String marshallingFormat, Class<T> unmarshalType) {
        if (data == null || data.isEmpty()) {
            return null;
        }
        MarshallingFormat format = ControllerUtils.getFormat(marshallingFormat);
        Marshaller marshaller = null;
        switch (format) {
            case JAXB: {
                marshaller = jaxbMarshaller;
                break;
            }
            case JSON: {
                marshaller = jsonMarshaller;
                break;
            }
            default: {
                marshaller = jsonMarshaller;
            }
        }
        Object instance = marshaller.unmarshall(data, unmarshalType);
        if (instance instanceof Wrapped) {
            return (T)((Wrapped)instance).unwrap();
        }
        return (T)instance;
    }

    public static String marshal(String marshallingFormat, Object entity) {
        MarshallingFormat format = ControllerUtils.getFormat(marshallingFormat);
        if (format == null) {
            throw new IllegalArgumentException("Unknown marshalling format " + marshallingFormat);
        }
        Marshaller marshaller = null;
        switch (format) {
            case JAXB: {
                marshaller = jaxbMarshaller;
                break;
            }
            case JSON: {
                marshaller = jsonMarshaller;
                break;
            }
            default: {
                marshaller = jsonMarshaller;
            }
        }
        return marshaller.marshall(entity);
    }

    public static String getUser() {
        return System.getProperty("org.kie.server.user", "kieserver");
    }

    public static String getPassword() {
        return System.getProperty("org.kie.server.pwd", "kieserver1!");
    }
}

