/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerControllerStorage;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Controller :: Server Controller")
@Path(value="/controller")
public class RestKieServerControllerImpl
extends KieServerControllerImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestKieServerControllerImpl.class);
    private KieServerControllerStorage storage = InMemoryKieServerControllerStorage.getInstance();

    @ApiOperation(value="Connect a new Kie Server instance to Controller", response=KieServerSetup.class)
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="server/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response connectKieServer(@Context HttpHeaders headers, @ApiParam(name="Kie Server instance identifier", required=true) @PathParam(value="id") String id, @ApiParam(name="Kie Server instance information", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"id\" : \"sample-server\",\n  \"version\" : \"7.14.0-SNAPSHOT\",\n  \"name\" : \"sample-server\",\n  \"location\" : \"http://localhost:8080/kie-server/services/rest/server\",\n  \"capabilities\" : [\n       \"KieServer\",       \"BRM\",       \"BPM\",       \"CaseMgmt\",       \"BPM-UI\",       \"BRP\",       \"DMN\",       \"Swagger\"    ],\n  \"messages\" : null\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<kie-server-info>\n  <id>sample-server</id>\n  <version>7.14.0-SNAPSHOT</version>\n  <name>sample-server</name>\n  <location>http://localhost:8080/kie-server/services/rest/server</location>\n  <capabilities>KieServer</capabilities>\n  <capabilities>BRM</capabilities>\n  <capabilities>BPM</capabilities>\n  <capabilities>CaseMgmt</capabilities>\n  <capabilities>BPM-UI</capabilities>\n  <capabilities>BRP</capabilities>\n  <capabilities>DMN</capabilities>\n  <capabilities>Swagger</capabilities>\n</kie-server-info>")})) String serverInfoPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        logger.debug("Received connect request from server with id {}", (Object)id);
        KieServerInfo serverInfo = ControllerUtils.unmarshal(serverInfoPayload, contentType, KieServerInfo.class);
        logger.debug("Server info {}", (Object)serverInfo);
        KieServerSetup serverSetup = this.connect(serverInfo);
        logger.info("Server with id '{}' connected", (Object)id);
        String response = ControllerUtils.marshal(contentType, serverSetup);
        logger.debug("Returning response for connect of server '{}': {}", (Object)id, (Object)response);
        return ControllerUtils.createCorrectVariant(response, headers, Response.Status.CREATED);
    }

    @ApiOperation(value="Remove a Kie Server instance from Controller")
    @ApiResponses(value={@ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="server/{id}")
    @Consumes(value={"application/xml", "application/json"})
    public Response disconnectKieServer(@Context HttpHeaders headers, @ApiParam(name="Kie Server instance identifier", required=true) @PathParam(value="id") String id, @ApiParam(name="Kie Server instance URL", required=true) @QueryParam(value="location") String serverLocation) {
        try {
            KieServerInfo serverInfo = new KieServerInfo(id, "", "", Collections.emptyList(), URLDecoder.decode(serverLocation, "UTF-8"));
            this.disconnect(serverInfo);
            logger.info("Server with id '{}' disconnected", (Object)id);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Cannot URL decode kie server location due to unsupported encoding exception", (Throwable)e);
        }
        return null;
    }
}

