/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Controller :: Management")
@Path(value="/controller/management")
public class RestSpecManagementServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestSpecManagementServiceImpl.class);
    private static final String REQUEST_FAILED_TOBE_PROCESSED = "Request failed to be processed due to: ";
    private SpecManagementServiceImpl specManagementService;

    @ApiOperation(value="Add new Container Specification to a given Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="servers/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response saveContainerSpec(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId, @ApiParam(name="Container information", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n  \"container-name\" : \"evaluation\",\n  \"release-id\" : {\n       \"group-id\" : \"evaluation\",\n        \"artifact-id\" : \"evaluation\",\n        \"version\" : \"1.0.0-SNAPSHOT\"\n    },\n  \"configuration\" : null,\n  \"status\" : \"STARTED\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-details>\n    <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n    <container-name>evaluation</container-name>\n    <release-id>\n        <artifact-id>evaluation</artifact-id>\n        <group-id>evaluation</group-id>\n        <version>1.0.0-SNAPSHOT</version>\n    </release-id>\n    <status>STARTED</status>\n</container-spec-details>")})) String containerSpecPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received save container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            this.specManagementService.saveContainerSpec(serverTemplateId, containerSpec);
            logger.debug("Returning response for save container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Update Container Specification in a given Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template or Container not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response updateContainerSpec(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId, @ApiParam(name="Container information", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n  \"container-name\" : \"evaluation\",\n  \"release-id\" : {\n       \"group-id\" : \"evaluation\",\n        \"artifact-id\" : \"evaluation\",\n        \"version\" : \"1.0.0-SNAPSHOT\"\n    },\n  \"configuration\" : null,\n  \"status\" : \"STARTED\"\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-spec-details>\n    <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n    <container-name>evaluation</container-name>\n    <release-id>\n        <artifact-id>evaluation</artifact-id>\n        <group-id>evaluation</group-id>\n        <version>1.0.0-SNAPSHOT</version>\n    </release-id>\n    <status>STARTED</status>\n</container-spec-details>")})) String containerSpecPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received update container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            this.specManagementService.updateContainerSpec(serverTemplateId, containerId, containerSpec);
            logger.debug("Returning response for update container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Add new Server Template to Controller")
    @ApiResponses(value={@ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @PUT
    @Path(value="servers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    public Response saveServerTemplate(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Kie Server Template information", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"server-id\" : \"sample-server\",\n  \"server-name\" : \"sample-server\",\n  \"capabilities\" : [\n       \"RULE\",       \"PROCESS\",       \"PLANNING\"    ],\n  \"container-specs\" : [ ],\n  \"server-config\" : { }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<server-template-details>\n  <server-id>sample-server</server-id>\n  <server-name>sample-server</server-name>\n  <configs/>\n  <capabilities>RULE</capabilities>\n  <capabilities>PROCESS</capabilities>\n  <capabilities>PLANNING</capabilities>\n</server-template-details>")})) String serverTemplatePayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received save server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = ControllerUtils.unmarshal(serverTemplatePayload, contentType, ServerTemplate.class);
            if (serverTemplate == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " not found", headers, Response.Status.NOT_FOUND);
            }
            logger.debug("Server template is {}", (Object)serverTemplate);
            this.specManagementService.saveServerTemplate(serverTemplate);
            logger.debug("Returning response for save server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Retrieve Server Template for a given id", response=ServerTemplate.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{id}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getServerTemplate(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = this.specManagementService.getServerTemplate(serverTemplateId);
            String response = ControllerUtils.marshal(contentType, serverTemplate);
            logger.debug("Returning response for get server template with id '{}': {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Retrieve all Server Templates", response=ServerTemplateList.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response listServerTemplates(@Context HttpHeaders headers) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server templates");
            String response = ControllerUtils.marshal(contentType, this.specManagementService.listServerTemplates());
            logger.debug("Returning response for get server templates: {}", (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Retrieve all Container Specification for a Server Template", response=ContainerSpecList.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{id}/containers")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response listContainerSpec(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get containers for server template with id {}", (Object)serverTemplateId);
            String response = ControllerUtils.marshal(contentType, this.specManagementService.listContainerSpec(serverTemplateId));
            logger.debug("Returning response for get containers for server templates with id {}: {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Get Container Specification for a given id and Server Template", response=ContainerSpec.class)
    @ApiResponses(value={@ApiResponse(code=404, message="Container Specification or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{id}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getContainerSpec(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get container {} for server template with id {}", (Object)containerId, (Object)serverTemplateId);
            ContainerSpec containerSpec = this.specManagementService.getContainerInfo(serverTemplateId, containerId);
            containerSpec.setServerTemplateKey(new ServerTemplateKey(containerSpec.getServerTemplateKey().getId(), containerSpec.getServerTemplateKey().getName()));
            String response = ControllerUtils.marshal(contentType, containerSpec);
            logger.debug("Returning response for get container {} for server templates with id {}: {}", new Object[]{containerId, serverTemplateId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Remove Container Specification from a given Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container Specification or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="servers/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteContainerSpec(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerSpecId) {
        try {
            this.specManagementService.deleteContainerSpec(serverTemplateId, containerSpecId);
            return null;
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove container with id {} from server template with id {} failed due to {}", new Object[]{containerSpecId, serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Remove Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @DELETE
    @Path(value="servers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    public Response deleteServerTemplate(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId) {
        try {
            this.specManagementService.deleteServerTemplate(serverTemplateId);
            return null;
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Update Container Specification for a given id and Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container Specification or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}/config/{capability}")
    @Consumes(value={"application/xml", "application/json"})
    public Response updateContainerConfig(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerSpecId, @ApiParam(name="Container capability", required=true) @PathParam(value="capability") String capabilityStr, @ApiParam(name="Container configuration", required=true, examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n\"org.kie.server.controller.api.model.spec.ProcessConfig\" : {\n       \"runtimeStrategy\" : \"SINGLETON\",\n       \"kbase\" : null,\n       \"ksession\" : null,\n       \"mergeMode\" : \"MERGE_COLLECTIONS\"\n  }\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<process-config>\n    <runtimeStrategy>SINGLETON</runtimeStrategy>\n    <mergeMode>MERGE_COLLECTIONS</mergeMode>\n</process-config>\n")})) String containerConfigPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            ContainerConfig containerConfig;
            Capability capability;
            if (capabilityStr.equals(Capability.PROCESS.name())) {
                capability = Capability.PROCESS;
                logger.debug("Received update container (with id {}) process config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, ProcessConfig.class);
            } else if (capabilityStr.equals(Capability.RULE.name())) {
                capability = Capability.RULE;
                logger.debug("Received update container (with id {}) rule config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, RuleConfig.class);
            } else {
                logger.debug("Not supported configuration type {}, returning bad request response", (Object)capabilityStr);
                return ControllerUtils.createCorrectVariant("Not supported configuration " + capabilityStr, headers, Response.Status.BAD_REQUEST);
            }
            logger.debug("Container configuration is {}", (Object)containerConfig);
            this.specManagementService.updateContainerConfig(serverTemplateId, containerSpecId, capability, containerConfig);
            logger.debug("Returning response for update container (with id {}) config '{}': CREATED", (Object)containerSpecId, (Object)containerConfig);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Stop Container for a given id and Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/stopped")
    @Consumes(value={"application/xml", "application/json"})
    public Response stopContainer(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.stopContainer(containerSpecKey);
            logger.debug("Returning response for stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Stop container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Start Container for a given id and Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/started")
    @Consumes(value={"application/xml", "application/json"})
    public Response startContainer(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.startContainer(containerSpecKey);
            logger.debug("Returning response for start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Start container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Activate Container for a given id and Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/activated")
    @Consumes(value={"application/xml", "application/json"})
    public Response activateContainer(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting activate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.activateContainer(containerSpecKey);
            logger.debug("Returning response for activate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Stop container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Deactivate Container for a given id and Server Template")
    @ApiResponses(value={@ApiResponse(code=404, message="Container or Server Template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/deactivated")
    @Consumes(value={"application/xml", "application/json"})
    public Response deactivateContainer(@Context HttpHeaders headers, @ApiParam(name="Kie Server Template identifier", required=true) @PathParam(value="id") String serverTemplateId, @ApiParam(name="Container identifier", required=true) @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting deactivate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            this.specManagementService.deactivateContainer(containerSpecKey);
            logger.debug("Returning response for deactivate container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Start container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void setSpecManagementService(SpecManagementServiceImpl specManagementService) {
        this.specManagementService = specManagementService;
    }
}

