/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerIllegalArgumentException;
import org.kie.server.controller.api.model.runtime.ContainerList;
import org.kie.server.controller.api.model.runtime.ServerInstanceKeyList;
import org.kie.server.controller.impl.service.RuntimeManagementServiceImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="Controller :: KIE Server instances and KIE containers")
@Path(value="/controller/runtime")
public class RestRuntimeManagementServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestRuntimeManagementServiceImpl.class);
    private static final String REQUEST_FAILED_TOBE_PROCESSED = "Request failed to be processed due to: ";
    private RuntimeManagementServiceImpl runtimeManagementService;

    @ApiOperation(value="Returns all KIE Server instances configured with the controller for a specified KIE Server template", response=ServerInstanceKeyList.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE Server instances", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"server-instance-key\" : [ {\n    \"server-instance-id\" : \"test-kie-server@localhost:8080\",\n    \"server-name\" : \"test-kie-server@localhost:8080\",\n    \"server-template-id\" : \"test-kie-server\",\n    \"server-url\" : \"http://localhost:8080/kie-server/services/rest/server\"\n  } ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<server-instance-key-list>\n    <server-instance-key>\n        <server-instance-id>test-kie-server@localhost:8080</server-instance-id>\n        <server-name>test-kie-server@localhost:8080</server-name>\n        <server-template-id>test-kie-server</server-template-id>\n        <server-url>http://localhost:8080/kie-server/services/rest/server</server-url>\n    </server-instance-key>\n</server-instance-key-list>")})), @ApiResponse(code=404, message="KIE Server template not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}/instances")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getServerInstances(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template for which you are retrieving KIE Server instances", required=true) @PathParam(value="serverTemplateId") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server template with id {}", (Object)serverTemplateId);
            ServerInstanceKeyList instances = this.runtimeManagementService.getServerInstances(serverTemplateId);
            String response = ControllerUtils.marshal(contentType, instances);
            logger.debug("Returning response for get server instance with server template id '{}': {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server instances using server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns all KIE containers for a specified KIE Server template and a specified KIE Server instance", response=ContainerList.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container instances", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-details\" : [ {\n    \"sever-template-id\" : \"test-kie-server\",\n    \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n    \"container-name\" : \"evaluation\",\n    \"url\" : \"http://localhost:8080/kie-server/services/rest/server/containers/evaluation_1.0.0-SNAPSHOT\",\n    \"sever-instance-id\" : \"test-kie-server@localhost:8080\",\n    \"container-release-id\" : {\n      \"group-id\" : \"evaluation\",\n      \"artifact-id\" : \"evaluation\",\n      \"version\" : \"1.0.0-SNAPSHOT\"\n    },\n    \"messages\" : [ {\n      \"severity\" : \"INFO\",\n      \"timestamp\" : {\n           \"java.util.Date\" : 1541568199713\n       },\n      \"content\" : [ \"Container evaluation_1.0.0-SNAPSHOT successfully created with module evaluation:evaluation:1.0.0-SNAPSHOT.\" ]\n    } ],\n    \"status\" : \"STARTED\"\n  } ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-details-list>\n    <container-details>\n        <sever-template-id>test-kie-server</sever-template-id>\n        <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n        <container-name>evaluation</container-name>\n        <url>http://localhost:8080/kie-server/services/rest/server/containers/evaluation_1.0.0-SNAPSHOT</url>\n        <sever-instance-id>test-kie-server@localhost:8080</sever-instance-id>\n        <container-release-id>\n            <artifact-id>evaluation</artifact-id>\n            <group-id>evaluation</group-id>\n            <version>1.0.0-SNAPSHOT</version>\n        </container-release-id>\n        <messages>\n            <content>Container evaluation_1.0.0-SNAPSHOT successfully created with module evaluation:evaluation:1.0.0-SNAPSHOT.</content>\n            <severity>INFO</severity>\n            <timestamp>2018-11-07T05:23:19.713Z</timestamp>\n        </messages>\n        <status>STARTED</status>\n    </container-details>\n</container-details-list>")})), @ApiResponse(code=404, message="Kie Server template or Kie Server instance not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}/instances/{serverInstanceId}/containers")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getServerInstanceContainers(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template associated with the KIE Server instance", required=true) @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="serverInstanceId", value="ID of the KIE Server instance for which you are retrieving KIE containers (example: default-kieserver-instance@localhost:8080)", required=true) @PathParam(value="serverInstanceId") String instanceId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get containers for server template with id {} and instance id {}", (Object)serverTemplateId, (Object)instanceId);
            ContainerList containers = this.runtimeManagementService.getServerInstanceContainers(serverTemplateId, instanceId);
            String response = ControllerUtils.marshal(contentType, containers);
            logger.debug("Returning response for get containers for server template with id {} and instance id {}: {}", new Object[]{serverTemplateId, instanceId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get containers using server template id {} and instance id {} failed due to {}", new Object[]{serverTemplateId, instanceId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @ApiOperation(value="Returns all instances of a specified KIE container in a specified KIE Server template", response=ContainerList.class)
    @ApiResponses(value={@ApiResponse(code=200, message="KIE container instances", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="{\n  \"container-details\" : [ {\n    \"sever-template-id\" : \"test-kie-server\",\n    \"container-id\" : \"evaluation_1.0.0-SNAPSHOT\",\n    \"container-name\" : \"evaluation\",\n    \"url\" : \"http://localhost:8080/kie-server/services/rest/server/containers/evaluation_1.0.0-SNAPSHOT\",\n    \"sever-instance-id\" : \"test-kie-server@localhost:8080\",\n    \"container-release-id\" : {\n      \"group-id\" : \"evaluation\",\n      \"artifact-id\" : \"evaluation\",\n      \"version\" : \"1.0.0-SNAPSHOT\"\n    },\n    \"messages\" : [ {\n      \"severity\" : \"INFO\",\n      \"timestamp\" : {\n           \"java.util.Date\" : 1541568199713\n       },\n      \"content\" : [ \"Container evaluation_1.0.0-SNAPSHOT successfully created with module evaluation:evaluation:1.0.0-SNAPSHOT.\" ]\n    } ],\n    \"status\" : \"STARTED\"\n  } ]\n}"), @ExampleProperty(mediaType="application/xml", value="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<container-details-list>\n    <container-details>\n        <sever-template-id>test-kie-server</sever-template-id>\n        <container-id>evaluation_1.0.0-SNAPSHOT</container-id>\n        <container-name>evaluation</container-name>\n        <url>http://localhost:8080/kie-server/services/rest/server/containers/evaluation_1.0.0-SNAPSHOT</url>\n        <sever-instance-id>test-kie-server@localhost:8080</sever-instance-id>\n        <container-release-id>\n            <artifact-id>evaluation</artifact-id>\n            <group-id>evaluation</group-id>\n            <version>1.0.0-SNAPSHOT</version>\n        </container-release-id>\n        <messages>\n            <content>Container evaluation_1.0.0-SNAPSHOT successfully created with module evaluation:evaluation:1.0.0-SNAPSHOT.</content>\n            <severity>INFO</severity>\n            <timestamp>2018-11-07T05:23:19.713Z</timestamp>\n        </messages>\n        <status>STARTED</status>\n    </container-details>\n</container-details-list>")})), @ApiResponse(code=404, message="KIE Server template or KIE container not found"), @ApiResponse(code=400, message="Controller exception"), @ApiResponse(code=500, message="Unexpected error")})
    @GET
    @Path(value="servers/{serverTemplateId}/containers/{containerId}/instances")
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/xml", "application/json"})
    public Response getServerTemplateContainers(@Context HttpHeaders headers, @ApiParam(name="serverTemplateId", value="ID of the KIE Server template for which you are retrieving KIE containers", required=true) @PathParam(value="serverTemplateId") String serverTemplateId, @ApiParam(name="containerId", value="ID of the KIE container to be retrieved", required=true) @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get container {} for server template with id {}", (Object)containerId, (Object)serverTemplateId);
            ContainerList containers = this.runtimeManagementService.getServerTemplateContainers(serverTemplateId, containerId);
            String response = ControllerUtils.marshal(contentType, containers);
            logger.debug("Returning response for get containers for server template with id {} and container id {}: {}", new Object[]{serverTemplateId, containerId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerIllegalArgumentException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get containers using server template id {} and container id {} failed due to {}", new Object[]{serverTemplateId, containerId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    public void setRuntimeManagementService(RuntimeManagementServiceImpl runtimeManagementService) {
        this.runtimeManagementService = runtimeManagementService;
    }
}

