/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.api.model.KieServerInfo;
import org.kie.server.controller.api.model.KieServerSetup;
import org.kie.server.controller.api.storage.KieServerControllerStorage;
import org.kie.server.controller.impl.KieServerControllerImpl;
import org.kie.server.controller.impl.storage.InMemoryKieServerControllerStorage;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/controller")
public class RestKieServerControllerImpl
extends KieServerControllerImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestKieServerControllerImpl.class);
    private KieServerControllerStorage storage = InMemoryKieServerControllerStorage.getInstance();

    @PUT
    @Path(value="server/{serverInstanceId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response connectKieServer(@Context HttpHeaders headers, @PathParam(value="serverInstanceId") String id, String serverInfoPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        logger.debug("Received connect request from server with id {}", (Object)id);
        KieServerInfo serverInfo = ControllerUtils.unmarshal(serverInfoPayload, contentType, KieServerInfo.class);
        if (serverInfo == null) {
            serverInfo = new KieServerInfo();
            serverInfo.setServerId(id);
        }
        logger.debug("Server info {}", (Object)serverInfo);
        KieServerSetup serverSetup = this.connect(serverInfo);
        logger.info("Server with id '{}' connected", (Object)id);
        String response = ControllerUtils.marshal(contentType, serverSetup);
        logger.debug("Returning response for connect of server '{}': {}", (Object)id, (Object)response);
        return ControllerUtils.createCorrectVariant(response, headers, Response.Status.CREATED);
    }

    @DELETE
    @Path(value="server/{serverInstanceId}")
    @Consumes(value={"application/xml", "application/json"})
    public Response disconnectKieServer(@Context HttpHeaders headers, @PathParam(value="serverInstanceId") String id, @QueryParam(value="location") String serverLocation) {
        try {
            String location = serverLocation == null || serverLocation.trim().length() == 0 ? "" : URLDecoder.decode(serverLocation, "UTF-8");
            KieServerInfo serverInfo = new KieServerInfo(id, "", "", Collections.emptyList(), location);
            this.disconnect(serverInfo);
            logger.info("Server with id '{}' disconnected", (Object)id);
        }
        catch (UnsupportedEncodingException e) {
            logger.debug("Cannot URL decode kie server location due to unsupported encoding exception", (Throwable)e);
        }
        return null;
    }
}

