/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.controller.rest;

import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.kie.server.controller.api.KieServerControllerException;
import org.kie.server.controller.api.KieServerControllerNotFoundException;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ContainerSpecList;
import org.kie.server.controller.api.model.spec.ProcessConfig;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.server.controller.api.model.spec.ServerTemplateList;
import org.kie.server.controller.impl.service.SpecManagementServiceImpl;
import org.kie.server.controller.rest.ControllerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/controller/management")
public class RestSpecManagementServiceImpl
extends SpecManagementServiceImpl {
    private static final Logger logger = LoggerFactory.getLogger(RestSpecManagementServiceImpl.class);
    private static final String REQUEST_FAILED_TOBE_PROCESSED = "Request failed to be processed due to: ";

    @PUT
    @Path(value="servers/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response saveContainerSpec(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId, String containerSpecPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received save container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            super.saveContainerSpec(serverTemplateId, containerSpec);
            logger.debug("Returning response for save container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="servers/{id}/containers/{containerId}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateContainerSpec(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId, String containerSpecPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received update container spec request for server template with id {}", (Object)serverTemplateId);
            ContainerSpec containerSpec = ControllerUtils.unmarshal(containerSpecPayload, contentType, ContainerSpec.class);
            logger.debug("Container spec is {}", (Object)containerSpec);
            super.updateContainerSpec(serverTemplateId, containerId, containerSpec);
            logger.debug("Returning response for update container spec request for server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save container spec request for server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @PUT
    @Path(value="servers/{id}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response saveServerTemplate(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, String serverTemplatePayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            if (super.getServerTemplate(serverTemplateId) != null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " already registered", headers, Response.Status.NOT_FOUND);
            }
            logger.debug("Received save server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = ControllerUtils.unmarshal(serverTemplatePayload, contentType, ServerTemplate.class);
            if (serverTemplate == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " not found", headers, Response.Status.NOT_FOUND);
            }
            logger.debug("Server template is {}", (Object)serverTemplate);
            super.saveServerTemplate(serverTemplate);
            logger.debug("Returning response for save server template with id '{}': CREATED", (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Save server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response getServerTemplate(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server template with id {}", (Object)serverTemplateId);
            ServerTemplate serverTemplate = super.getServerTemplate(serverTemplateId);
            if (serverTemplate == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " not found", headers, Response.Status.NOT_FOUND);
            }
            String response = ControllerUtils.marshal(contentType, serverTemplate);
            logger.debug("Returning response for get server template with id '{}': {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server template id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers")
    @Produces(value={"application/xml", "application/json"})
    public Response listServerTemplates(@Context HttpHeaders headers) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get server templates");
            Collection servers = super.listServerTemplates();
            String response = ControllerUtils.marshal(contentType, new ServerTemplateList(servers));
            logger.debug("Returning response for get server templates: {}", (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers/{id}/containers")
    @Produces(value={"application/xml", "application/json"})
    public Response listContainerSpec(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get containers for server template with id {}", (Object)serverTemplateId);
            Collection containerSpecs = super.listContainerSpec(serverTemplateId);
            String response = ControllerUtils.marshal(contentType, new ContainerSpecList(containerSpecs));
            logger.debug("Returning response for get containers for server templates with id {}: {}", (Object)serverTemplateId, (Object)response);
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="servers/{id}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    public Response getContainerSpec(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            logger.debug("Received get container {} for server template with id {}", (Object)containerId, (Object)serverTemplateId);
            ServerTemplate serverTemplate = super.getServerTemplate(serverTemplateId);
            if (serverTemplate == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " not found", headers, Response.Status.NOT_FOUND);
            }
            ContainerSpec containerSpec = serverTemplate.getContainerSpec(containerId);
            if (containerSpec == null) {
                return ControllerUtils.createCorrectVariant("Server template " + serverTemplateId + " does not have container with id " + containerId, headers, Response.Status.NOT_FOUND);
            }
            containerSpec.setServerTemplateKey(new ServerTemplateKey(serverTemplate.getId(), serverTemplate.getName()));
            String response = ControllerUtils.marshal(contentType, containerSpec);
            logger.debug("Returning response for get container {} for server templates with id {}: {}", new Object[]{containerId, serverTemplateId, response});
            return ControllerUtils.createCorrectVariant(response, headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Get server templates failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="servers/{id}/containers/{containerId}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteContainerSpec(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerSpecId) {
        try {
            super.deleteContainerSpec(serverTemplateId, containerSpecId);
            return null;
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove container with id {} from server template with id {} failed due to {}", new Object[]{containerSpecId, serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @DELETE
    @Path(value="servers/{id}")
    @Produces(value={"application/xml", "application/json"})
    public Response deleteServerTemplate(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId) {
        try {
            super.deleteServerTemplate(serverTemplateId);
            return null;
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="servers/{id}/containers/{containerId}/config/{capability}")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response updateContainerConfig(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerSpecId, @PathParam(value="capability") String capabilityStr, String containerConfigPayload) {
        String contentType = ControllerUtils.getContentType(headers);
        try {
            ContainerConfig containerConfig;
            Capability capability;
            if (capabilityStr.equals(Capability.PROCESS.name())) {
                capability = Capability.PROCESS;
                logger.debug("Received update container (with id {}) process config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, ProcessConfig.class);
            } else if (capabilityStr.equals(Capability.RULE.name())) {
                capability = Capability.RULE;
                logger.debug("Received update container (with id {}) rule config request for server template with id {}", (Object)containerSpecId, (Object)serverTemplateId);
                containerConfig = (ContainerConfig)ControllerUtils.unmarshal(containerConfigPayload, contentType, RuleConfig.class);
            } else {
                logger.debug("Not supported configuration type {}, returning bad request response", (Object)capabilityStr);
                return ControllerUtils.createCorrectVariant("Not supported configuration " + capabilityStr, headers, Response.Status.BAD_REQUEST);
            }
            logger.debug("Container configuration is {}", (Object)containerConfig);
            super.updateContainerConfig(serverTemplateId, containerSpecId, capability, containerConfig);
            logger.debug("Returning response for update container (with id {}) config '{}': CREATED", (Object)containerSpecId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.CREATED);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (KieServerControllerException e) {
            return ControllerUtils.createCorrectVariant(REQUEST_FAILED_TOBE_PROCESSED + e.getMessage(), headers, Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            logger.error("Remove server template with id {} failed due to {}", new Object[]{serverTemplateId, e.getMessage(), e});
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/stopped")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response stopContainer(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            super.stopContainer(containerSpecKey);
            logger.debug("Returning response for stop container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Stop container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @POST
    @Path(value="servers/{id}/containers/{containerId}/status/started")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response startContainer(@Context HttpHeaders headers, @PathParam(value="id") String serverTemplateId, @PathParam(value="containerId") String containerId) {
        logger.debug("Requesting start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
        try {
            ContainerSpecKey containerSpecKey = new ContainerSpecKey();
            containerSpecKey.setId(containerId);
            containerSpecKey.setServerTemplateKey(new ServerTemplateKey(serverTemplateId, ""));
            super.startContainer(containerSpecKey);
            logger.debug("Returning response for start container with id {} server instance: {}", (Object)containerId, (Object)serverTemplateId);
            return ControllerUtils.createCorrectVariant("", headers, Response.Status.OK);
        }
        catch (KieServerControllerNotFoundException e) {
            return ControllerUtils.createCorrectVariant(e.getMessage(), headers, Response.Status.NOT_FOUND);
        }
        catch (Exception e) {
            logger.error("Start container failed due to {}", (Object)e.getMessage(), (Object)e);
            return ControllerUtils.createCorrectVariant("Unknown error " + e.getMessage(), headers, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

