/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestJmsXstreamSharedBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter(value=0)
    public MarshallingFormat marshallingFormat;
    @Parameterized.Parameter(value=1)
    public KieServicesConfiguration configuration;

    @Parameterized.Parameters(name="{index}: {0} {1}")
    public static Collection<Object[]> data() {
        KieServicesConfiguration restConfiguration = RestJmsXstreamSharedBaseIntegrationTest.createKieServicesRestConfiguration();
        ArrayList<Object[]> parameterData = new ArrayList<Object[]>(Arrays.asList(new Object[][]{{MarshallingFormat.XSTREAM, restConfiguration}}));
        if (TestConfig.getRemotingUrl() != null && !TestConfig.skipJMS()) {
            KieServicesConfiguration jmsConfiguration = RestJmsXstreamSharedBaseIntegrationTest.createKieServicesJmsConfiguration();
            parameterData.addAll(Arrays.asList(new Object[][]{{MarshallingFormat.XSTREAM, jmsConfiguration}}));
        }
        return parameterData;
    }

    @Override
    protected KieServicesClient createDefaultClient() {
        if (TestConfig.isLocalServer()) {
            KieServicesConfiguration localServerConfig = KieServicesFactory.newRestConfiguration((String)TestConfig.getHttpUrl(), null, null).setMarshallingFormat(this.marshallingFormat);
            localServerConfig.setTimeout(100000L);
            return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)localServerConfig);
        }
        this.configuration.setMarshallingFormat(this.marshallingFormat);
        return KieServicesFactory.newKieServicesClient((KieServicesConfiguration)this.configuration);
    }
}

