/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.cli.MavenCli;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesException;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.client.RuleServicesClient;
import org.kie.server.integrationtests.config.JacksonRestEasyTestConfig;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.kie.server.services.impl.KieServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerBaseIntegrationTest {
    protected static Logger logger = LoggerFactory.getLogger(KieServerBaseIntegrationTest.class);
    protected static TJWSEmbeddedJaxrsServer server;
    protected static MavenRepository repository;
    protected KieServicesClient client;
    protected RuleServicesClient ruleClient;
    private static boolean commonParentDeployed;
    private static SimpleDateFormat serverIdSuffixDateFormat;

    @BeforeClass
    public static void setupClass() throws Exception {
        if (TestConfig.isLocalServer()) {
            KieServerBaseIntegrationTest.startServer();
        }
        KieServerBaseIntegrationTest.setupCustomSettingsXml();
        KieServerBaseIntegrationTest.warmUpServer();
    }

    private static void setupCustomSettingsXml() {
        if (!TestConfig.isLocalServer()) {
            String clientDeploymentSettingsXml = ClassLoader.class.getResource("/kie-server-testing-client-deployment-settings.xml").getFile();
            System.setProperty("kie.maven.settings.custom", clientDeploymentSettingsXml);
        }
    }

    private static void warmUpServer() throws Exception {
        logger.info("Warming-up the server by creating dummy container and then immediately destroying it...");
        KieServicesConfiguration config = KieServerBaseIntegrationTest.createKieServicesRestConfiguration();
        config.setTimeout(30000L);
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
        ReleaseId warmUpReleaseId = new ReleaseId("org.kie.server.testing", "server-warm-up", "42");
        KieServerBaseIntegrationTest.createAndDeployKJar(warmUpReleaseId);
        KieServerBaseIntegrationTest.assertSuccess(client.createContainer("warm-up-kjar", new KieContainerResource("warm-up-kjar", warmUpReleaseId)));
        KieServerBaseIntegrationTest.assertSuccess(client.disposeContainer("warm-up-kjar"));
        logger.info("Server warm-up done.");
    }

    @Before
    public void setup() throws Exception {
        this.startClient();
        this.disposeAllContainers();
    }

    @AfterClass
    public static void tearDown() {
        if (TestConfig.isLocalServer()) {
            server.stop();
            System.clearProperty("java.naming.factory.initial");
        }
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
        try {
            this.ruleClient = (RuleServicesClient)kieServicesClient.getServicesClient(RuleServicesClient.class);
        }
        catch (KieServicesException kieServicesException) {
            // empty catch block
        }
    }

    protected void disposeAllContainers() {
        ServiceResponse response = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        List containers = ((KieContainerResourceList)response.getResult()).getContainers();
        if (containers != null) {
            for (KieContainerResource container : containers) {
                this.client.disposeContainer(container.getContainerId());
            }
        }
    }

    private void startClient() throws Exception {
        this.client = this.createDefaultClient();
    }

    protected abstract KieServicesClient createDefaultClient() throws Exception;

    private static void startServer() throws Exception {
        System.setProperty("java.naming.factory.initial", "bitronix.tm.jndi.BitronixInitialContextFactory");
        System.setProperty("org.kie.server.bypass.auth.user", "true");
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.kie.server.integrationtests.jbpm.util.FixedUserGroupCallbackImpl");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm-ds");
        System.setProperty("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        server = new TJWSEmbeddedJaxrsServer();
        server.setPort(TestConfig.getAllocatedPort().intValue());
        server.start();
        KieServerEnvironment.setServerId((String)("target/" + KieServerBaseIntegrationTest.class.getSimpleName() + "@" + serverIdSuffixDateFormat.format(new Date())));
        KieServerEnvironment.setServerName((String)"KieServer");
        server.getDeployment().getRegistry().addSingletonResource((Object)new KieServerRestImpl());
        KieServerImpl kieServer = KieServerLocator.getInstance();
        List extensions = kieServer.getServerExtensions();
        for (KieServerExtension extension : extensions) {
            List components = extension.getAppComponents(SupportedTransports.REST);
            for (Object component : components) {
                server.getDeployment().getRegistry().addSingletonResource(component);
            }
        }
        server.getDeployment().setProviderFactory(JacksonRestEasyTestConfig.createRestEasyProviderFactory());
    }

    protected static void buildAndDeployMavenProject(String basedir) {
        logger.debug("Building and deploying Maven project from basedir '{}'.", (Object)basedir);
        ClassLoader classLoaderBak = Thread.currentThread().getContextClassLoader();
        MavenCli cli = new MavenCli();
        String[] mvnArgs = TestConfig.isLocalServer() ? new String[]{"-B", "clean", "install"} : new String[]{"-B", "clean", "deploy"};
        int mvnRunResult = cli.doMain(mvnArgs, basedir, System.out, System.out);
        if (mvnRunResult != 0) {
            throw new RuntimeException("Error while building Maven project from basedir " + basedir + ". Return code=" + mvnRunResult);
        }
        Thread.currentThread().setContextClassLoader(classLoaderBak);
        logger.debug("Maven project successfully built and deployed!");
    }

    protected static void buildAndDeployCommonMavenParent() {
        if (!commonParentDeployed) {
            KieServerBaseIntegrationTest.buildAndDeployMavenProject(ClassLoader.class.getResource("/kjars-sources/common-parent").getFile());
        } else {
            logger.debug("Common parent project already deployed, nothing to do here.");
        }
    }

    protected static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieServerBaseIntegrationTest.createAndDeployJar(ks, releaseId, drl);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    private static void createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/org/pkg1/r" + i + ".drl", drls[i]);
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        repository = MavenRepository.getMavenRepository();
        repository.deployArtifact((org.kie.api.builder.ReleaseId)releaseId, jar, pom);
    }

    protected static void assertSuccess(ServiceResponse<?> response) {
        ServiceResponse.ResponseType type = response.getType();
        Assert.assertEquals((String)("Expected SUCCESS, but got " + type + "! Response: " + response), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)type);
    }

    protected static void assertResultContainsString(String result, String expectedString) {
        Assert.assertTrue((String)("Expecting string '" + expectedString + "' in result, but got: " + result), (boolean)result.contains(expectedString));
    }

    protected static void assertResultContainsStringRegex(String result, String regex) {
        Assert.assertTrue((String)("Regex '" + regex + "' does not matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    protected static KieServicesConfiguration createKieServicesJmsConfiguration() {
        try {
            InitialContext context = TestConfig.getInitialRemoteContext();
            Queue requestQueue = (Queue)context.lookup(TestConfig.getRequestQueueJndi());
            Queue responseQueue = (Queue)context.lookup(TestConfig.getResponseQueueJndi());
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(TestConfig.getConnectionFactory());
            KieServicesConfiguration jmsConfiguration = KieServicesFactory.newJMSConfiguration((ConnectionFactory)connectionFactory, (Queue)requestQueue, (Queue)responseQueue, (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
            return jmsConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JMS client configuration!", e);
        }
    }

    protected static KieServicesConfiguration createKieServicesRestConfiguration() {
        return KieServicesFactory.newRestConfiguration((String)TestConfig.getHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }

    protected ClientRequest newRequest(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed request URI was specified: '" + uriString + "'!", e);
        }
        if (TestConfig.isLocalServer()) {
            return new ClientRequest(uriString);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(TestConfig.getUsername(), TestConfig.getPassword()));
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor((HttpClient)client);
        return new ClientRequest(uriString, (ClientExecutor)executor);
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    static {
        commonParentDeployed = false;
        serverIdSuffixDateFormat = new SimpleDateFormat("yyyy-MM-DD-HHmmss_SSS");
    }
}

