/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.naming.InitialContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.cli.MavenCli;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClient4Executor;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.MavenRepository;
import org.kie.server.api.KieServerEnvironment;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.KieServerInstanceList;
import org.kie.server.controller.rest.RestKieServerControllerAdminImpl;
import org.kie.server.controller.rest.RestKieServerControllerImpl;
import org.kie.server.integrationtests.config.JacksonRestEasyTestConfig;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.remote.rest.common.resource.KieServerRestImpl;
import org.kie.server.services.api.KieServerExtension;
import org.kie.server.services.api.SupportedTransports;
import org.kie.server.services.impl.KieServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerBaseIntegrationTest {
    protected static Logger logger = LoggerFactory.getLogger(KieServerBaseIntegrationTest.class);
    protected static TJWSEmbeddedJaxrsServer server;
    protected static TJWSEmbeddedJaxrsServer controller;
    protected static MavenRepository repository;
    private static KieServerImpl kieServer;
    protected KieServicesClient client;
    private static boolean commonParentDeployed;
    private static SimpleDateFormat serverIdSuffixDateFormat;
    private static HttpClient httpClient;

    @BeforeClass
    public static void setupClass() throws Exception {
        if (TestConfig.isLocalServer()) {
            System.setProperty("java.naming.factory.initial", "bitronix.tm.jndi.BitronixInitialContextFactory");
            KieServerBaseIntegrationTest.startKieController();
            KieServerBaseIntegrationTest.startKieServer();
        }
        KieServerBaseIntegrationTest.setupCustomSettingsXml();
        KieServerBaseIntegrationTest.warmUpServer();
    }

    private static void setupCustomSettingsXml() {
        if (!TestConfig.isLocalServer()) {
            String clientDeploymentSettingsXml = ClassLoader.class.getResource("/kie-server-testing-client-deployment-settings.xml").getFile();
            System.setProperty("kie.maven.settings.custom", clientDeploymentSettingsXml);
        }
    }

    private static void warmUpServer() throws Exception {
        logger.info("Warming-up the server by creating dummy container and then immediately destroying it...");
        KieServicesConfiguration config = KieServerBaseIntegrationTest.createKieServicesRestConfiguration();
        config.setTimeout(30000L);
        KieServicesClient client = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)config);
        ReleaseId warmUpReleaseId = new ReleaseId("org.kie.server.testing", "server-warm-up", "42");
        KieServerBaseIntegrationTest.createAndDeployKJar(warmUpReleaseId);
        KieServerBaseIntegrationTest.assertSuccess(client.createContainer("warm-up-kjar", new KieContainerResource("warm-up-kjar", warmUpReleaseId)));
        KieServerBaseIntegrationTest.assertSuccess(client.disposeContainer("warm-up-kjar"));
        logger.info("Server warm-up done.");
    }

    @Before
    public void setup() throws Exception {
        this.startClient();
        this.disposeAllContainers();
        this.disposeAllServerInstances();
    }

    @AfterClass
    public static void tearDown() {
        if (TestConfig.isLocalServer()) {
            KieServerBaseIntegrationTest.stopKieServer();
            KieServerBaseIntegrationTest.stopKieController();
            System.clearProperty("java.naming.factory.initial");
        }
    }

    protected void disposeAllContainers() {
        ServiceResponse response = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        List containers = ((KieContainerResourceList)response.getResult()).getContainers();
        if (containers != null) {
            for (KieContainerResource container : containers) {
                this.client.disposeContainer(container.getContainerId());
            }
        }
    }

    protected void disposeAllServerInstances() throws Exception {
        if (TestConfig.isLocalServer() || TestConfig.isControllerProvided()) {
            ClientRequest clientRequest = this.newRequest(TestConfig.getControllerHttpUrl() + "/admin/servers");
            ClientResponse responseList = clientRequest.accept(MediaType.APPLICATION_XML_TYPE).get(KieServerInstanceList.class);
            Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)responseList.getStatus());
            KieServerInstance[] instanceList = ((KieServerInstanceList)responseList.getEntity()).getKieServerInstances();
            if (instanceList != null && instanceList.length > 0) {
                for (KieServerInstance kieServerInstance : instanceList) {
                    clientRequest = this.newRequest(TestConfig.getControllerHttpUrl() + "/admin/server/" + kieServerInstance.getIdentifier());
                    ClientResponse responseDelete = clientRequest.accept(MediaType.APPLICATION_XML_TYPE).delete(KieServerInstanceList.class);
                    Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)responseDelete.getStatus());
                    responseDelete.releaseConnection();
                }
            }
        }
    }

    private void startClient() throws Exception {
        this.client = this.createDefaultClient();
    }

    protected abstract KieServicesClient createDefaultClient() throws Exception;

    protected static void startKieController() {
        if (controller != null) {
            throw new RuntimeException("Kie execution controller is already created!");
        }
        controller = new TJWSEmbeddedJaxrsServer();
        controller.setPort(TestConfig.getControllerAllocatedPort().intValue());
        controller.start();
        controller.getDeployment().getRegistry().addSingletonResource((Object)new RestKieServerControllerImpl());
        controller.getDeployment().getRegistry().addSingletonResource((Object)new RestKieServerControllerAdminImpl());
        controller.getDeployment().setProviderFactory(JacksonRestEasyTestConfig.createRestEasyProviderFactory());
    }

    protected static void stopKieController() {
        if (controller == null) {
            throw new RuntimeException("Kie execution controller is already stopped!");
        }
        controller.stop();
        controller = null;
    }

    protected static void startKieServer() {
        if (server != null) {
            throw new RuntimeException("Kie execution server is already created!");
        }
        System.setProperty("org.kie.server.bypass.auth.user", "true");
        System.setProperty("org.jbpm.ht.callback", "custom");
        System.setProperty("org.jbpm.ht.custom.callback", "org.kie.server.integrationtests.jbpm.util.FixedUserGroupCallbackImpl");
        System.setProperty("org.kie.server.persistence.ds", "jdbc/jbpm-ds");
        System.setProperty("org.kie.server.persistence.tm", "org.hibernate.service.jta.platform.internal.BitronixJtaPlatform");
        System.setProperty("org.kie.server.controller", TestConfig.getControllerHttpUrl());
        System.setProperty("org.kie.server.controller.user", TestConfig.getUsername());
        System.setProperty("org.kie.server.controller.pwd", TestConfig.getPassword());
        System.setProperty("org.kie.server.location", TestConfig.getKieServerHttpUrl());
        System.setProperty("org.kie.server.repo", "./target");
        if (KieServerEnvironment.getServerId() == null) {
            KieServerEnvironment.setServerId((String)(KieServerBaseIntegrationTest.class.getSimpleName() + "@" + serverIdSuffixDateFormat.format(new Date())));
            KieServerEnvironment.setServerName((String)"KieServer");
        }
        server = new TJWSEmbeddedJaxrsServer();
        server.setPort(TestConfig.getKieServerAllocatedPort().intValue());
        server.start();
        kieServer = new KieServerImpl();
        server.getDeployment().getRegistry().addSingletonResource((Object)new KieServerRestImpl(kieServer));
        List extensions = kieServer.getServerExtensions();
        for (KieServerExtension extension : extensions) {
            List components = extension.getAppComponents(SupportedTransports.REST);
            for (Object component : components) {
                server.getDeployment().getRegistry().addSingletonResource(component);
            }
        }
        server.getDeployment().setProviderFactory(JacksonRestEasyTestConfig.createRestEasyProviderFactory());
    }

    protected static void stopKieServer() {
        if (server == null) {
            throw new RuntimeException("Kie execution server is already stopped!");
        }
        kieServer.destroy();
        server.stop();
        server = null;
    }

    protected static void buildAndDeployMavenProject(String basedir) {
        int mvnRunResult;
        logger.debug("Building and deploying Maven project from basedir '{}'.", (Object)basedir);
        ClassLoader classLoaderBak = Thread.currentThread().getContextClassLoader();
        MavenCli cli = new MavenCli();
        ArrayList<String> mvnArgs = TestConfig.isLocalServer() ? new ArrayList<String>(Arrays.asList("-B", "clean", "install")) : new ArrayList<String>(Arrays.asList("-B", "-e", "clean", "deploy"));
        String kjarsBuildSettingsXml = TestConfig.getKjarsBuildSettingsXml();
        if (kjarsBuildSettingsXml != null && !kjarsBuildSettingsXml.isEmpty()) {
            mvnArgs.add("-s");
            mvnArgs.add(kjarsBuildSettingsXml);
        }
        if ((mvnRunResult = cli.doMain(mvnArgs.toArray(new String[mvnArgs.size()]), basedir, System.out, System.out)) != 0) {
            throw new RuntimeException("Error while building Maven project from basedir " + basedir + ". Return code=" + mvnRunResult);
        }
        Thread.currentThread().setContextClassLoader(classLoaderBak);
        logger.debug("Maven project successfully built and deployed!");
    }

    protected static void buildAndDeployCommonMavenParent() {
        if (!commonParentDeployed) {
            KieServerBaseIntegrationTest.buildAndDeployMavenProject(ClassLoader.class.getResource("/kjars-sources/common-parent").getFile());
        } else {
            logger.debug("Common parent project already deployed, nothing to do here.");
        }
    }

    protected static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieServerBaseIntegrationTest.createAndDeployJar(ks, releaseId, drl);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    private static void createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/org/pkg1/r" + i + ".drl", drls[i]);
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        repository = MavenRepository.getMavenRepository();
        repository.deployArtifact((org.kie.api.builder.ReleaseId)releaseId, jar, pom);
    }

    protected static void assertSuccess(ServiceResponse<?> response) {
        ServiceResponse.ResponseType type = response.getType();
        Assert.assertEquals((String)("Expected SUCCESS, but got " + type + "! Response: " + response), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)type);
    }

    protected static void assertResultContainsString(String result, String expectedString) {
        Assert.assertTrue((String)("Expecting string '" + expectedString + "' in result, but got: " + result), (boolean)result.contains(expectedString));
    }

    protected static void assertResultContainsStringRegex(String result, String regex) {
        Assert.assertTrue((String)("Regex '" + regex + "' does not matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    protected static void assertResultNotContainingStringRegex(String result, String regex) {
        Assert.assertFalse((String)("Regex '" + regex + "' matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    protected static void assertNullOrEmpty(String errorMessage, Collection<?> result) {
        if (result != null) {
            Assert.assertTrue((String)errorMessage, (result.size() == 0 ? 1 : 0) != 0);
        }
    }

    protected static void assertNullOrEmpty(String errorMessage, Object[] result) {
        if (result != null) {
            Assert.assertTrue((String)errorMessage, (result.length == 0 ? 1 : 0) != 0);
        }
    }

    protected static KieServicesConfiguration createKieServicesJmsConfiguration() {
        try {
            InitialContext context = TestConfig.getInitialRemoteContext();
            Queue requestQueue = (Queue)context.lookup(TestConfig.getRequestQueueJndi());
            Queue responseQueue = (Queue)context.lookup(TestConfig.getResponseQueueJndi());
            ConnectionFactory connectionFactory = (ConnectionFactory)context.lookup(TestConfig.getConnectionFactory());
            KieServicesConfiguration jmsConfiguration = KieServicesFactory.newJMSConfiguration((ConnectionFactory)connectionFactory, (Queue)requestQueue, (Queue)responseQueue, (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
            return jmsConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create JMS client configuration!", e);
        }
    }

    protected static KieServicesConfiguration createKieServicesRestConfiguration() {
        return KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
    }

    protected ClientRequest newRequest(String uriString) {
        URI uri;
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed request URI was specified: '" + uriString + "'!", e);
        }
        if (httpClient == null) {
            if (TestConfig.isLocalServer()) {
                RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(1000).setConnectTimeout(1000).setSocketTimeout(1000).build();
                httpClient = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).build();
            } else {
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(uri.getHost(), uri.getPort()), (Credentials)new UsernamePasswordCredentials(TestConfig.getUsername(), TestConfig.getPassword()));
                httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
            }
        }
        ApacheHttpClient4Executor executor = new ApacheHttpClient4Executor(httpClient);
        return new ClientRequest(uriString, (ClientExecutor)executor);
    }

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    static {
        commonParentDeployed = false;
        serverIdSuffixDateFormat = new SimpleDateFormat("yyyy-MM-DD-HHmmss_SSS");
    }
}

