/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.Calendar;
import java.util.concurrent.TimeoutException;
import org.kie.api.executor.STATUS;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.RequestInfoInstance;
import org.kie.server.client.JobServicesClient;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.ProcessServicesClient;

public class KieServerSynchronization {
    private static final long SERVICE_TIMEOUT = 30000L;
    private static final long TIMEOUT_BETWEEN_CALLS = 200L;

    public static void waitForJobToFinish(JobServicesClient jobServicesClient, Long jobId) throws Exception {
        long timeoutTime = Calendar.getInstance().getTimeInMillis() + 30000L;
        while (Calendar.getInstance().getTimeInMillis() < timeoutTime) {
            RequestInfoInstance result = jobServicesClient.getRequestById(jobId, false, false);
            if (STATUS.CANCELLED.toString().equals(result.getStatus()) || STATUS.DONE.toString().equals(result.getStatus()) || STATUS.ERROR.toString().equals(result.getStatus())) {
                return;
            }
            Thread.sleep(200L);
        }
        throw new TimeoutException("Timeout while waiting for job executor to finish job.");
    }

    public static void waitForKieServerSynchronization(KieServicesClient client, int numberOfExpectedContainers) throws Exception {
        long timeoutTime = Calendar.getInstance().getTimeInMillis() + 30000L;
        while (Calendar.getInstance().getTimeInMillis() < timeoutTime) {
            ServiceResponse containersList = client.listContainers();
            if (((KieContainerResourceList)containersList.getResult()).getContainers() == null) {
                if (numberOfExpectedContainers == 0) {
                    return;
                }
            } else if (numberOfExpectedContainers == ((KieContainerResourceList)containersList.getResult()).getContainers().size()) {
                boolean containersInitializing = false;
                for (KieContainerResource container : ((KieContainerResourceList)containersList.getResult()).getContainers()) {
                    if (!KieContainerStatus.CREATING.equals((Object)container.getStatus()) && !KieContainerStatus.DISPOSING.equals((Object)container.getStatus())) continue;
                    containersInitializing = true;
                }
                if (!containersInitializing) {
                    return;
                }
            }
            Thread.sleep(200L);
        }
        throw new TimeoutException("Timeout while waiting for kie server synchronization.");
    }

    public static void waitForProcessInstanceToFinish(ProcessServicesClient processClient, String containerId, long processInstanceId) throws Exception {
        long timeoutTime = Calendar.getInstance().getTimeInMillis() + 30000L;
        while (Calendar.getInstance().getTimeInMillis() < timeoutTime) {
            ProcessInstance processInstance = processClient.getProcessInstance(containerId, Long.valueOf(processInstanceId));
            if (Integer.valueOf(2).equals(processInstance.getState()) || Integer.valueOf(3).equals(processInstance.getState())) {
                return;
            }
            Thread.sleep(200L);
        }
        throw new TimeoutException("Timeout while waiting for process instance to finish.");
    }
}

