/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.util.Collection;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.kie.server.api.model.ServiceResponse;

public class KieServerAssert {
    public static void assertSuccess(ServiceResponse<?> response) {
        ServiceResponse.ResponseType type = response.getType();
        Assert.assertEquals((String)("Expected SUCCESS, but got " + type + "! Response: " + response), (Object)ServiceResponse.ResponseType.SUCCESS, (Object)type);
    }

    public static void assertFailure(ServiceResponse<?> response) {
        ServiceResponse.ResponseType type = response.getType();
        Assert.assertEquals((String)("Expected FAILURE, but got " + type + "! Response: " + response), (Object)ServiceResponse.ResponseType.FAILURE, (Object)type);
    }

    public static void assertResultContainsString(String result, String expectedString) {
        Assert.assertTrue((String)("Expecting string '" + expectedString + "' in result, but got: " + result), (boolean)result.contains(expectedString));
    }

    public static void assertResultContainsStringRegex(String result, String regex) {
        Assert.assertTrue((String)("Regex '" + regex + "' does not matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    public static void assertResultNotContainingStringRegex(String result, String regex) {
        Assert.assertFalse((String)("Regex '" + regex + "' matches result string '" + result + "'!"), (boolean)Pattern.compile(regex, 32).matcher(result).matches());
    }

    public static void assertNullOrEmpty(String errorMessage, Collection<?> result) {
        if (result != null) {
            Assert.assertTrue((String)errorMessage, (result.size() == 0 ? 1 : 0) != 0);
        }
    }

    public static void assertNullOrEmpty(String errorMessage, Object[] result) {
        if (result != null) {
            Assert.assertTrue((String)errorMessage, (result.length == 0 ? 1 : 0) != 0);
        }
    }

    public static void assertNullOrEmpty(String result) {
        if (result != null) {
            Assert.assertTrue((String)"String is not empty.", (boolean)result.trim().isEmpty());
        }
    }
}

