/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.KieContainerResourceList;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.controller.api.model.KieServerInstance;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.controller.client.KieServerControllerClient;
import org.kie.server.integrationtests.controller.client.KieServerMgmtControllerClient;
import org.kie.server.integrationtests.shared.KieControllerExecutor;
import org.kie.server.integrationtests.shared.KieServerExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KieServerBaseIntegrationTest {
    protected static Logger logger = LoggerFactory.getLogger(KieServerBaseIntegrationTest.class);
    protected KieServicesClient client;
    protected static KieControllerExecutor controller;
    protected static KieServerExecutor server;
    protected static final long DEFAULT_TIMEOUT = 60000L;
    protected Map<String, Class<?>> extraClasses = new ConcurrentHashMap();

    @BeforeClass
    public static void setupClass() throws Exception {
        if (TestConfig.isLocalServer()) {
            System.setProperty("java.naming.factory.initial", "bitronix.tm.jndi.BitronixInitialContextFactory");
            controller = new KieControllerExecutor();
            controller.startKieController();
            server = new KieServerExecutor();
            server.startKieServer();
        }
        KieServerBaseIntegrationTest.setupCustomSettingsXml();
    }

    private static void setupCustomSettingsXml() {
        if (!TestConfig.isLocalServer()) {
            String deploymentSettings = TestConfig.getKieClientDeploymentSettings();
            if (deploymentSettings == null) {
                deploymentSettings = ClassLoader.class.getResource("/kie-server-testing-client-deployment-settings.xml").getFile();
            }
            System.setProperty("kie.maven.settings.custom", deploymentSettings);
        }
    }

    @Before
    public void setup() throws Exception {
        this.startClient();
        this.disposeAllContainers();
        this.disposeAllServerInstances();
    }

    @AfterClass
    public static void tearDown() {
        if (TestConfig.isLocalServer()) {
            server.stopKieServer();
            controller.stopKieController();
            System.clearProperty("java.naming.factory.initial");
        }
    }

    protected void disposeAllContainers() {
        ServiceResponse response = this.client.listContainers();
        Assert.assertEquals((Object)ServiceResponse.ResponseType.SUCCESS, (Object)response.getType());
        List containers = ((KieContainerResourceList)response.getResult()).getContainers();
        if (containers != null) {
            for (KieContainerResource container : containers) {
                this.client.disposeContainer(container.getContainerId());
            }
        }
    }

    protected void disposeAllServerInstances() throws Exception {
        if (TestConfig.isLocalServer() || TestConfig.isControllerProvided()) {
            this.disposeServerInstances();
            this.disposeServerTemplates();
        }
    }

    private void disposeServerInstances() {
        KieServerInstance[] serverInstrances;
        KieServerControllerClient controllerClient = TestConfig.isLocalServer() ? new KieServerControllerClient(TestConfig.getControllerHttpUrl(), null, null) : new KieServerControllerClient(TestConfig.getControllerHttpUrl(), TestConfig.getUsername(), TestConfig.getPassword());
        controllerClient.setMarshallingFormat(MarshallingFormat.JAXB);
        for (KieServerInstance serverInstance : serverInstrances = controllerClient.listKieServerInstances().getKieServerInstances()) {
            controllerClient.deleteKieServerInstance(serverInstance.getIdentifier());
        }
        controllerClient.close();
    }

    private void disposeServerTemplates() {
        KieServerMgmtControllerClient mgmtControllerClient = TestConfig.isLocalServer() ? new KieServerMgmtControllerClient(TestConfig.getControllerHttpUrl(), null, null) : new KieServerMgmtControllerClient(TestConfig.getControllerHttpUrl(), TestConfig.getUsername(), TestConfig.getPassword());
        mgmtControllerClient.setMarshallingFormat(MarshallingFormat.JAXB);
        Collection<ServerTemplate> serverTemplates = mgmtControllerClient.listServerTemplates();
        for (ServerTemplate serverTemplate : serverTemplates) {
            mgmtControllerClient.deleteServerTemplate(serverTemplate.getId());
        }
        mgmtControllerClient.close();
    }

    private void startClient() throws Exception {
        this.client = this.createDefaultClient();
    }

    protected abstract KieServicesClient createDefaultClient() throws Exception;

    public static void cleanupSingletonSessionId() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (tempDir.exists()) {
            String[] jbpmSerFiles;
            for (String file : jbpmSerFiles = tempDir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith("-jbpmSessionId.ser");
                }
            })) {
                new File(tempDir, file).delete();
            }
        }
    }

    protected KieServicesClient createDefaultClient(KieServicesConfiguration configuration, MarshallingFormat marshallingFormat) throws Exception {
        KieServicesClient kieServicesClient = null;
        configuration.setTimeout(60000L);
        configuration.setMarshallingFormat(marshallingFormat);
        configuration.addJaxbClasses(new HashSet(this.extraClasses.values()));
        this.additionalConfiguration(configuration);
        if (this.extraClasses.size() > 0) {
            ClassLoader classLoader = this.extraClasses.values().iterator().next().getClassLoader();
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration, (ClassLoader)classLoader);
        } else {
            kieServicesClient = KieServicesFactory.newKieServicesClient((KieServicesConfiguration)configuration);
        }
        this.setupClients(kieServicesClient);
        return kieServicesClient;
    }

    protected void addExtraCustomClasses(Map<String, Class<?>> extraClasses) throws Exception {
    }

    protected void additionalConfiguration(KieServicesConfiguration configuration) throws Exception {
    }

    protected void setupClients(KieServicesClient kieServicesClient) {
    }
}

