/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.controller;

import org.codehaus.cargo.container.Container;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.RemoteContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.deployable.Deployable;
import org.codehaus.cargo.container.deployable.DeployableType;
import org.codehaus.cargo.container.deployable.WAR;
import org.codehaus.cargo.container.deployer.Deployer;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.generic.deployable.DefaultDeployableFactory;
import org.codehaus.cargo.generic.deployer.DefaultDeployerFactory;
import org.kie.server.integrationtests.config.TestConfig;

public class ContainerRemoteController {
    private Configuration configuration;
    private Container container;
    private Deployer deployer;

    public ContainerRemoteController(String cargoContainerId, String containerPort) {
        this.configuration = new DefaultConfigurationFactory().createConfiguration(cargoContainerId, ContainerType.REMOTE, ConfigurationType.RUNTIME);
        this.container = (RemoteContainer)new DefaultContainerFactory().createContainer(cargoContainerId, ContainerType.REMOTE, this.configuration);
        this.deployer = new DefaultDeployerFactory().createDeployer(this.container);
        this.configuration.setProperty("cargo.servlet.port", containerPort);
        if (TestConfig.isCargoRemoteUsernameProvided()) {
            this.configuration.setProperty("cargo.remote.username", TestConfig.getCargoRemoteUsername());
        }
        if (TestConfig.isCargoRemotePasswordProvided()) {
            this.configuration.setProperty("cargo.remote.password", TestConfig.getCargoRemotePassword());
        }
        if (TestConfig.isWebLogicHomeProvided()) {
            String wlserverHome = TestConfig.getWebLogicHome().matches(".*/wlserver") ? TestConfig.getWebLogicHome() : TestConfig.getWebLogicHome() + "/wlserver";
            this.configuration.setProperty("cargo.weblogic.installation.home", wlserverHome);
        }
    }

    public void undeployWarFile(String context, String warFilePath) {
        WAR deployable = (WAR)new DefaultDeployableFactory().createDeployable(this.container.getId(), warFilePath, DeployableType.WAR);
        deployable.setContext(context);
        this.deployer.undeploy((Deployable)deployable);
    }

    public void deployWarFile(String context, String warFilePath) {
        WAR deployable = (WAR)new DefaultDeployableFactory().createDeployable(this.container.getId(), warFilePath, DeployableType.WAR);
        deployable.setContext(context);
        this.deployer.deploy((Deployable)deployable);
    }
}

