/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.project.MavenProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.junit.Assert;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.scanner.MavenRepository;
import org.kie.scanner.embedder.MavenProjectLoader;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.integrationtests.config.TestConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieServerDeployer {
    protected static Logger logger = LoggerFactory.getLogger(KieServerDeployer.class);
    private static MavenRepository repository;
    private static boolean commonParentDeployed;

    public static void buildAndDeployMavenProject(String basedir) {
        logger.debug("Building and deploying Maven project from basedir '{}'.", (Object)basedir);
        ClassLoader classLoaderBak = Thread.currentThread().getContextClassLoader();
        System.setProperty("maven.multiModuleProjectDirectory", basedir);
        MavenCli cli = new MavenCli();
        ArrayList<String> mvnArgs = TestConfig.isLocalServer() ? new ArrayList<String>(Arrays.asList("-B", "clean", "install")) : new ArrayList<String>(Arrays.asList("-B", "-e", "clean", "deploy"));
        String kjarsBuildSettingsXml = TestConfig.getKjarsBuildSettingsXml();
        if (kjarsBuildSettingsXml != null && !kjarsBuildSettingsXml.isEmpty()) {
            mvnArgs.add("-s");
            mvnArgs.add(kjarsBuildSettingsXml);
        }
        int mvnRunResult = cli.doMain(mvnArgs.toArray(new String[mvnArgs.size()]), basedir, System.out, System.err);
        Thread.currentThread().setContextClassLoader(classLoaderBak);
        if (mvnRunResult != 0) {
            throw new RuntimeException("Error while building Maven project from basedir " + basedir + ". Return code=" + mvnRunResult);
        }
        logger.debug("Maven project successfully built and deployed!");
    }

    public static void buildAndDeployCommonMavenParent() {
        if (!commonParentDeployed) {
            KieServerDeployer.buildAndDeployMavenProject(ClassLoader.class.getResource("/kjars-sources/common-parent").getFile());
        } else {
            logger.debug("Common parent project already deployed, nothing to do here.");
        }
    }

    public static void createAndDeployKJar(ReleaseId releaseId) {
        String drl = "package org.pkg1\nglobal java.util.List list;declare Message\n    text : String\nend\nrule echo dialect \"mvel\"\nwhen\n    $m : Message()\nthen\n    $m.text = \"echo:\" + $m.text;\nend\nrule X when\n    msg : String()\nthen\n    list.add(msg);\nend\n";
        KieServices ks = KieServices.Factory.get();
        KieServerDeployer.createAndDeployJar(ks, releaseId, drl);
        ks.getRepository().removeKieModule((org.kie.api.builder.ReleaseId)releaseId);
    }

    private static void createAndDeployJar(KieServices ks, ReleaseId releaseId, String ... drls) {
        KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)releaseId);
        for (int i = 0; i < drls.length; ++i) {
            if (drls[i] == null) continue;
            kfs.write("src/main/resources/org/pkg1/r" + i + ".drl", drls[i]);
        }
        byte[] pom = kfs.read("pom.xml");
        KieBuilder kb = ks.newKieBuilder(kfs).buildAll();
        Assert.assertFalse((String)kb.getResults().getMessages(new Message.Level[]{Message.Level.ERROR}).toString(), (boolean)kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR}));
        InternalKieModule kieModule = (InternalKieModule)ks.getRepository().getKieModule((org.kie.api.builder.ReleaseId)releaseId);
        byte[] jar = kieModule.getBytes();
        KieServerDeployer.getRepository().installArtifact((org.kie.api.builder.ReleaseId)releaseId, jar, pom);
    }

    public static MavenRepository getRepository() {
        if (repository == null) {
            KieServices ks = KieServices.Factory.get();
            ReleaseId initReleaseId = new ReleaseId("org.kie.server.initial", "init-maven-repo", "42");
            KieFileSystem kfs = ks.newKieFileSystem().generateAndWritePomXML((org.kie.api.builder.ReleaseId)initReleaseId);
            byte[] pom = kfs.read("pom.xml");
            MavenProject minimalMavenProject = MavenProjectLoader.parseMavenPom((InputStream)new ByteArrayInputStream(pom));
            repository = MavenRepository.getMavenRepository((MavenProject)minimalMavenProject);
        }
        return repository;
    }

    static {
        commonParentDeployed = false;
    }
}

