/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.integrationtests.shared.basetests;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.client.KieServicesClient;
import org.kie.server.client.KieServicesConfiguration;
import org.kie.server.client.KieServicesFactory;
import org.kie.server.common.rest.Authenticator;
import org.kie.server.integrationtests.config.TestConfig;
import org.kie.server.integrationtests.shared.basetests.KieServerBaseIntegrationTest;

@RunWith(value=Parameterized.class)
public abstract class RestOnlyBaseIntegrationTest
extends KieServerBaseIntegrationTest {
    @Parameterized.Parameter
    public MarshallingFormat marshallingFormat;
    private static Client httpClient;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({MarshallingFormat.JAXB}, {MarshallingFormat.JSON});
    }

    @Override
    protected KieServicesClient createDefaultClient() throws Exception {
        KieServicesConfiguration config = TestConfig.isLocalServer() ? KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), null, null) : KieServicesFactory.newRestConfiguration((String)TestConfig.getKieServerHttpUrl(), (String)TestConfig.getUsername(), (String)TestConfig.getPassword());
        return this.createDefaultClient(config, this.marshallingFormat);
    }

    protected MediaType getMediaType() {
        switch (this.marshallingFormat) {
            case JAXB: {
                return MediaType.APPLICATION_XML_TYPE;
            }
            case JSON: {
                return MediaType.APPLICATION_JSON_TYPE;
            }
            case XSTREAM: {
                return MediaType.APPLICATION_XML_TYPE;
            }
        }
        throw new RuntimeException("Unrecognized marshalling format: " + this.marshallingFormat);
    }

    protected WebTarget newRequest(String uriString) {
        if (httpClient == null) {
            httpClient = new ResteasyClientBuilder().establishConnectionTimeout(10L, TimeUnit.SECONDS).socketTimeout(10L, TimeUnit.SECONDS).register((Object)new Authenticator(TestConfig.getUsername(), TestConfig.getPassword())).build();
        }
        return httpClient.target(uriString);
    }

    protected <T> Entity<T> createEntity(T requestObject) {
        return Entity.entity(requestObject, (MediaType)this.getMediaType());
    }
}

