/*
 * Decompiled with CFR 0.152.
 */
package org.kie.server.remote.rest.drools;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.kie.server.api.marshalling.MarshallingFormat;
import org.kie.server.api.model.KieServiceResponse;
import org.kie.server.api.model.ServiceResponse;
import org.kie.server.remote.rest.common.Header;
import org.kie.server.remote.rest.common.util.RestUtils;
import org.kie.server.services.api.KieContainerCommandService;
import org.kie.server.services.api.KieServerRegistry;
import org.kie.server.services.impl.locator.ContainerLocatorProvider;
import org.kie.server.services.impl.marshal.MarshallerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="KIE session assets")
@Path(value="server/containers/instances/{containerId}")
public class CommandResource {
    private static final Logger logger = LoggerFactory.getLogger(CommandResource.class);
    private KieContainerCommandService delegate;
    private KieServerRegistry registry;
    private MarshallerHelper marshallerHelper;

    public CommandResource() {
    }

    public CommandResource(KieContainerCommandService delegate, KieServerRegistry registry) {
        this.delegate = delegate;
        this.registry = registry;
        this.marshallerHelper = new MarshallerHelper(registry);
    }

    @ApiOperation(value="Executes one or more runtime commands")
    @ApiResponses(value={@ApiResponse(code=200, message="Successful execution", response=ServiceResponse.class), @ApiResponse(code=500, message="Unexpected error", response=ServiceResponse.class), @ApiResponse(code=204, message="Command execute successfully, but without response", response=ServiceResponse.class)})
    @POST
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/xml", "application/json"})
    public Response manageContainer(@Context HttpHeaders headers, @ApiParam(value="Container id where rules should be evaluated on", required=true) @PathParam(value="containerId") String id, @ApiParam(value="Commands to be executed on rule engine given as BatchExecutionCommand type", required=true) String cmdPayload) {
        Variant v = RestUtils.getVariant((HttpHeaders)headers);
        String contentType = RestUtils.getContentType((HttpHeaders)headers);
        String classType = RestUtils.getClassType((HttpHeaders)headers);
        MarshallingFormat format = MarshallingFormat.fromType((String)contentType);
        if (format == null) {
            format = MarshallingFormat.valueOf((String)contentType);
        }
        logger.debug("Received request with content '{}'", (Object)cmdPayload);
        Header conversationIdHeader = RestUtils.buildConversationIdHeader((String)id, (KieServerRegistry)this.registry, (HttpHeaders)headers);
        ServiceResponse result = this.delegate.callContainer(id, cmdPayload, format, classType);
        Response.Status status = result.getType() == KieServiceResponse.ResponseType.FAILURE ? Response.Status.INTERNAL_SERVER_ERROR : Response.Status.OK;
        try {
            String response = this.marshallerHelper.marshal(id, format.getType(), (Object)result, ContainerLocatorProvider.get().getLocator());
            logger.debug("Returning {} response with content '{}'", (Object)status, (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)status, (Header[])new Header[]{conversationIdHeader});
        }
        catch (IllegalArgumentException e) {
            String response = this.marshallerHelper.marshal(format.getType(), (Object)result);
            logger.debug("Returning {} response with content '{}'", (Object)status, (Object)response);
            return RestUtils.createResponse((Object)response, (Variant)v, (Response.Status)status, (Header[])new Header[]{conversationIdHeader});
        }
    }
}

